/*
 * Decompiled with CFR 0.152.
 */
package hvlnoise;

import Jama.Matrix;
import hvlnoise.ElectricField;
import hvlnoise.ElectricalSystem;
import hvlnoise.HighVoltageLine;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;

public class AudibleNoise
implements Serializable {
    private HighVoltageLine hvl;
    private ElectricField electricField;
    private ArrayList<Double> noiseCoefficientsL5;
    private ArrayList<Double> noiseCoefficientsL50;
    private Hashtable<String, Integer> indexTransformationTable;
    private ArrayList<Matrix> conductorPositions;
    private double percentageOfRain;

    public AudibleNoise(HighVoltageLine hvl, ElectricField electricField) {
        this.hvl = hvl;
        this.electricField = electricField;
    }

    public void calculateAudibleNoise(double rainRateL5, double rainRateL50, double percentageOfRain) {
        this.noiseCoefficientsL5 = new ArrayList();
        this.noiseCoefficientsL50 = new ArrayList();
        this.indexTransformationTable = new Hashtable();
        this.conductorPositions = new ArrayList();
        int overallSubconductorIndex = 0;
        ElectricalSystem[] acThreePhaseSystems = this.hvl.getAcThreePhaseSystems();
        int[] acThreePhaseSystemIndices = this.hvl.getAcThreePhaseSystemIndices();
        int numberOfAcThreePhaseSystems = acThreePhaseSystems.length;
        for (int phaseIndex = 0; phaseIndex < 3; ++phaseIndex) {
            for (int i = 0; i < numberOfAcThreePhaseSystems; ++i) {
                ElectricalSystem system = acThreePhaseSystems[i];
                int numberOfSubconductors = system.getNumberOfSubconductors();
                double noiseCoefficientL5 = 0.0;
                double noiseCoefficientL50 = 0.0;
                for (int j = 0; j < numberOfSubconductors; ++j) {
                    double subconductorDiameter = system.getSubconductorRadius(j) / 10.0 * 2.0;
                    double[] soundPressureLevels = this.getSoundLevelsL5AndL50OfSubconductor(overallSubconductorIndex, numberOfSubconductors, subconductorDiameter, rainRateL5, rainRateL50);
                    noiseCoefficientL5 += Math.pow(10.0, soundPressureLevels[0] / 10.0);
                    noiseCoefficientL50 += Math.pow(10.0, soundPressureLevels[1] / 10.0);
                    ++overallSubconductorIndex;
                }
                this.noiseCoefficientsL5.add(noiseCoefficientL5);
                this.noiseCoefficientsL50.add(noiseCoefficientL50);
                this.indexTransformationTable.put("ES" + String.valueOf(acThreePhaseSystemIndices[i]) + "Ph" + String.valueOf(phaseIndex), this.noiseCoefficientsL5.size() - 1);
                this.conductorPositions.add(system.getConductorAbsolutePosition(phaseIndex));
            }
        }
        ElectricalSystem[] acSinglePhaseSystems = this.hvl.getAcSinglePhaseSystems();
        int[] acSinglePhaseSystemIndices = this.hvl.getAcSinglePhaseSystemIndices();
        int numberOfAcSinglePhaseSystems = acSinglePhaseSystems.length;
        for (int i = 0; i < numberOfAcSinglePhaseSystems; ++i) {
            ElectricalSystem system = acSinglePhaseSystems[i];
            int numberOfSubconductors = system.getNumberOfSubconductors();
            double noiseCoefficientL5 = 0.0;
            double noiseCoefficientL50 = 0.0;
            for (int j = 0; j < numberOfSubconductors; ++j) {
                double subconductorDiameter = system.getSubconductorRadius(j) / 10.0 * 2.0;
                double[] soundPressureLevels = this.getSoundLevelsL5AndL50OfSubconductor(overallSubconductorIndex, numberOfSubconductors, subconductorDiameter, rainRateL5, rainRateL50);
                noiseCoefficientL5 += Math.pow(10.0, soundPressureLevels[0] / 10.0);
                noiseCoefficientL50 += Math.pow(10.0, soundPressureLevels[1] / 10.0);
                ++overallSubconductorIndex;
            }
            this.noiseCoefficientsL5.add(noiseCoefficientL5);
            this.noiseCoefficientsL50.add(noiseCoefficientL50);
            this.indexTransformationTable.put("ES" + String.valueOf(acSinglePhaseSystemIndices[i]) + "Ph" + String.valueOf(0), this.noiseCoefficientsL5.size() - 1);
            this.conductorPositions.add(system.getConductorAbsolutePosition(0));
        }
        ElectricalSystem[] dcTwoPhaseSystems = this.hvl.getDcTwoPhaseSystems();
        int[] dcTwoPhaseSystemIndices = this.hvl.getDcTwoPhaseSystemIndices();
        int numberOfDcTwoPhaseSystems = dcTwoPhaseSystems.length;
        for (int phaseIndex = 0; phaseIndex < 2; ++phaseIndex) {
            for (int i = 0; i < numberOfDcTwoPhaseSystems; ++i) {
                ElectricalSystem system = dcTwoPhaseSystems[i];
                int numberOfSubconductors = system.getNumberOfSubconductors();
                double noiseCoefficientL5 = 0.0;
                double noiseCoefficientL50 = 0.0;
                for (int j = 0; j < numberOfSubconductors; ++j) {
                    double subconductorDiameter = system.getSubconductorRadius(j) / 10.0 * 2.0;
                    double[] soundPressureLevels = this.getSoundLevelsL5AndL50OfSubconductor(overallSubconductorIndex, numberOfSubconductors, subconductorDiameter, rainRateL5, rainRateL50);
                    noiseCoefficientL5 += Math.pow(10.0, soundPressureLevels[0] / 10.0);
                    noiseCoefficientL50 += Math.pow(10.0, soundPressureLevels[1] / 10.0);
                    ++overallSubconductorIndex;
                }
                this.noiseCoefficientsL5.add(noiseCoefficientL5);
                this.noiseCoefficientsL50.add(noiseCoefficientL50);
                this.indexTransformationTable.put("ES" + String.valueOf(dcTwoPhaseSystemIndices[i]) + "Ph" + String.valueOf(phaseIndex), this.noiseCoefficientsL5.size() - 1);
                this.conductorPositions.add(system.getConductorAbsolutePosition(phaseIndex));
            }
        }
        this.percentageOfRain = percentageOfRain;
    }

    public double getSoundLevelL5AtLocation(Matrix locationVector) {
        double sumOfSoundPressureSquares = 0.0;
        for (int i = 0; i < this.noiseCoefficientsL5.size(); ++i) {
            double R = locationVector.minus(this.conductorPositions.get(i)).norm2();
            sumOfSoundPressureSquares += this.noiseCoefficientsL5.get(i) * Math.pow(R, -1.0) * Math.pow(10.0, -0.002 * R);
        }
        double P_L5 = 10.0 * Math.log10(sumOfSoundPressureSquares);
        return P_L5;
    }

    public double getSoundLevelL50AtLocation(Matrix locationVector) {
        double sumOfSoundPressureSquares = 0.0;
        for (int i = 0; i < this.noiseCoefficientsL50.size(); ++i) {
            double R = locationVector.minus(this.conductorPositions.get(i)).norm2();
            sumOfSoundPressureSquares += this.noiseCoefficientsL50.get(i) * Math.pow(R, -1.0) * Math.pow(10.0, -0.002 * R);
        }
        double P_L50 = 10.0 * Math.log10(sumOfSoundPressureSquares);
        return P_L50;
    }

    public double getSoundLevelLeqDuringRainAtLocation(Matrix locationVector) {
        double P_L5 = this.getSoundLevelL5AtLocation(locationVector);
        double P_L50 = this.getSoundLevelL50AtLocation(locationVector);
        double sigma = (P_L5 - P_L50) / 1.64;
        return P_L50 + 0.115 * Math.pow(sigma, 2.0);
    }

    public double getSoundLevelLeqDuringPeriodAtLocation(Matrix locationVector) {
        double P_Leq_rain = this.getSoundLevelLeqDuringRainAtLocation(locationVector);
        double P_Leq_period = 10.0 * Math.log10(this.percentageOfRain / 100.0 * Math.pow(10.0, P_Leq_rain / 10.0));
        return P_Leq_period;
    }

    public double getSoundPowerLevelLeqDuringRainOfConductor(int systemIndex, int conductorIndex) {
        int noiseCoefficientIndex = this.indexTransformationTable.get("ES" + String.valueOf(systemIndex) + "Ph" + String.valueOf(conductorIndex));
        double Lw_5 = 10.0 * Math.log10(this.noiseCoefficientsL5.get(noiseCoefficientIndex)) + 2.74;
        double Lw_50 = 10.0 * Math.log10(this.noiseCoefficientsL50.get(noiseCoefficientIndex)) + 2.74;
        double sigma = (Lw_5 - Lw_50) / 1.64;
        return Lw_50 + 0.115 * Math.pow(sigma, 2.0);
    }

    private double[] getSoundLevelsL5AndL50OfSubconductor(int overallSubconductorIndex, int numberOfSubconductors, double subconductorDiameter, double rainRateL5, double rainRateL50) {
        double E_max = this.electricField.getMaximumRmsFieldOfSubconductor(overallSubconductorIndex);
        double E_avg = this.electricField.getAverageRmsFieldOfSubconductor(overallSubconductorIndex);
        double kFactor = E_max / E_avg;
        double A_L5 = numberOfSubconductors == 1 ? 44.0 * Math.log10(subconductorDiameter) - 31.6 - 665.0 / E_max : (numberOfSubconductors == 2 ? 10.0 * Math.log10(numberOfSubconductors) + 44.0 * Math.log10(subconductorDiameter) - 36.5 - 665.0 / E_max : 10.0 * Math.log10(numberOfSubconductors) + 44.0 * Math.log10(subconductorDiameter) - 69.3 - 665.0 / E_max + 22.9 * kFactor);
        double E_c = 24.4 / Math.pow(subconductorDiameter, 0.24);
        if (numberOfSubconductors > 8) {
            E_c -= 0.25 * ((double)numberOfSubconductors - 8.0);
        }
        double delta_A_L50 = numberOfSubconductors < 3 ? 8.2 - 14.2 * E_c / E_max : 2.4 - 14.2 * E_c / E_max + 8.0 * kFactor;
        double L5CorrectionDb = this.getL5RainRateCorrection(rainRateL5);
        double L50CorrectionDb = this.getL50RainRateCorrection(rainRateL50);
        double P0_L5 = A_L5 + 114.3 + L5CorrectionDb;
        double P0_L50 = A_L5 + 114.3 + delta_A_L50 + L50CorrectionDb;
        double[] soundPressureLevels = new double[]{P0_L5, P0_L50};
        return soundPressureLevels;
    }

    private double getL5RainRateCorrection(double rainRate) {
        double p1 = 4.367;
        double p2 = -84.13;
        double p3 = 4683.0;
        double p4 = -27400.0;
        double p5 = -4714.0;
        double q1 = -40.59;
        double q2 = 952.5;
        double q3 = 7425.0;
        double q4 = 1005.0;
        double L5CorrectionDb = (p1 * Math.pow(rainRate, 4.0) + p2 * Math.pow(rainRate, 3.0) + p3 * Math.pow(rainRate, 2.0) + p4 * rainRate + p5) / (Math.pow(rainRate, 4.0) + q1 * Math.pow(rainRate, 3.0) + q2 * Math.pow(rainRate, 2.0) + q3 * rainRate + q4);
        return L5CorrectionDb;
    }

    private double getL50RainRateCorrection(double rainRate) {
        double p1 = 23.4;
        double p2 = -233.5;
        double p3 = 1597.0;
        double p4 = 1509.0;
        double p5 = -2097.0;
        double q1 = 35.58;
        double q2 = -356.4;
        double q3 = 2846.0;
        double q4 = 684.1;
        double L50CorrectionDb = (p1 * Math.pow(rainRate, 4.0) + p2 * Math.pow(rainRate, 3.0) + p3 * Math.pow(rainRate, 2.0) + p4 * rainRate + p5) / (Math.pow(rainRate, 4.0) + q1 * Math.pow(rainRate, 3.0) + q2 * Math.pow(rainRate, 2.0) + q3 * rainRate + q4);
        return L50CorrectionDb;
    }
}

