/*
 * Decompiled with CFR 0.152.
 */
package hvlnoise;

import hvlnoise.AudibleNoise;
import hvlnoise.ElectricField;
import hvlnoise.HighVoltageLine;
import javax.swing.JDialog;
import javax.swing.JProgressBar;

public class CalculationThread
extends Thread {
    private JDialog calculationProgress;
    private JProgressBar calculationProgressBar;
    private HighVoltageLine hvl;
    private double calculationAccuracy;
    private double rainRateL5;
    private double rainRateL50;
    private double percentageOfRain;
    private ElectricField electricField;
    private AudibleNoise audibleNoise;
    private boolean exceptionThrown;

    public CalculationThread(JDialog calculationProgress, JProgressBar calculationProgressBar, HighVoltageLine hvl, double calculationAccuracy, double rainRateL5, double rainRateL50, double percentageOfRain) {
        this.calculationProgressBar = calculationProgressBar;
        this.calculationProgress = calculationProgress;
        this.hvl = hvl;
        this.calculationAccuracy = calculationAccuracy;
        this.rainRateL5 = rainRateL5;
        this.rainRateL50 = rainRateL50;
        this.percentageOfRain = percentageOfRain;
        this.exceptionThrown = false;
    }

    public CalculationThread() {
    }

    public void run() {
        try {
            this.electricField = new ElectricField(this.hvl, this.calculationAccuracy, this.calculationProgressBar);
            this.electricField.calculateElectricField();
            this.audibleNoise = new AudibleNoise(this.hvl, this.electricField);
            this.audibleNoise.calculateAudibleNoise(this.rainRateL5, this.rainRateL50, this.percentageOfRain);
            this.hvl.calculateAndDrawSoundPowerLevelAnnotations(this.audibleNoise);
            this.calculationProgressBar.setValue(100);
            this.calculationProgress.setVisible(false);
        }
        catch (Exception exception) {
            this.exceptionThrown = true;
            this.calculationProgress.setVisible(false);
        }
    }

    public ElectricField getElectricField() {
        return this.electricField;
    }

    public AudibleNoise getAudibleNoise() {
        return this.audibleNoise;
    }

    public void setElectricField(ElectricField electricField) {
        this.electricField = electricField;
    }

    public void setAudibleNoise(AudibleNoise audibleNoise) {
        this.audibleNoise = audibleNoise;
    }

    public boolean wasExceptionThrown() {
        return this.exceptionThrown;
    }
}

