/*
 * Decompiled with CFR 0.152.
 */
package hvlnoise;

import hvlnoise.DecimalNumberVerifierFlag;
import hvlnoise.DecimalNumberVerifierType;
import java.awt.Color;
import java.util.regex.Pattern;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.jfree.chart.ChartColor;

public class DecimalNumberVerifier
extends InputVerifier {
    private DecimalNumberVerifierType verifierType;
    private double minValue;
    private double maxValue;
    private DecimalNumberVerifierFlag verifierFlag;

    public DecimalNumberVerifier(DecimalNumberVerifierType verifierType, DecimalNumberVerifierFlag verifierFlag) {
        this.verifierType = verifierType;
        this.verifierFlag = verifierFlag;
    }

    public DecimalNumberVerifier(DecimalNumberVerifierType verifierType, DecimalNumberVerifierFlag verifierFlag, double minValue, double maxValue) {
        this.verifierType = verifierType;
        this.verifierFlag = verifierFlag;
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    public boolean verify(JComponent input) {
        JTextField textField = (JTextField)input;
        boolean returnValue = false;
        switch (this.verifierType) {
            case DECIMAL_NUMBER: {
                returnValue = this.verifyDecimalNumber(textField);
                break;
            }
            case POSITIVE_DECIMAL_NUMBER_WITHOUT_ZERO: {
                returnValue = this.verifyPositiveDecimalNumberWithoutZero(textField);
                break;
            }
            case POSITIVE_DECIMAL_NUMBER_WITH_ZERO: {
                returnValue = this.verifyPositiveDecimalNumberWithZero(textField);
                break;
            }
            case DECIMAL_NUMBER_WITHIN_RANGE: {
                returnValue = this.verifyDecimalNumberWithinRange(textField);
            }
        }
        return returnValue;
    }

    private boolean verifyDecimalNumber(JTextField textField) {
        if (Pattern.matches("-?[0-9]+(\\.[0-9]+)?", textField.getText()) || textField.getText().equals("")) {
            textField.setToolTipText(null);
            textField.setForeground(Color.black);
            this.verifierFlag.setVerificationOk();
            return true;
        }
        textField.setToolTipText(null);
        textField.setForeground(ChartColor.LIGHT_RED);
        this.verifierFlag.setVerificationNotOk();
        return false;
    }

    private boolean verifyPositiveDecimalNumberWithoutZero(JTextField textField) {
        if (this.verifyDecimalNumber(textField)) {
            if (textField.getText().equals("")) {
                return true;
            }
            double value = Double.valueOf(textField.getText());
            if (value > 0.0) {
                return true;
            }
            textField.setToolTipText("Input value should be greater than 0.0!");
            textField.setForeground(ChartColor.LIGHT_RED);
            this.verifierFlag.setVerificationNotOk();
            return false;
        }
        return false;
    }

    private boolean verifyPositiveDecimalNumberWithZero(JTextField textField) {
        if (this.verifyDecimalNumber(textField)) {
            if (textField.getText().equals("")) {
                return true;
            }
            double value = Double.valueOf(textField.getText());
            if (value >= 0.0) {
                return true;
            }
            textField.setToolTipText("Input value should be greater or equal than 0.0!");
            textField.setForeground(ChartColor.LIGHT_RED);
            this.verifierFlag.setVerificationNotOk();
            return false;
        }
        return false;
    }

    private boolean verifyDecimalNumberWithinRange(JTextField textField) {
        if (this.verifyDecimalNumber(textField)) {
            if (textField.getText().equals("")) {
                return true;
            }
            double value = Double.valueOf(textField.getText());
            if (value >= this.minValue && value <= this.maxValue) {
                return true;
            }
            textField.setToolTipText("Input value should be between " + String.valueOf(this.minValue) + " and " + String.valueOf(this.maxValue) + "!");
            textField.setForeground(ChartColor.LIGHT_RED);
            this.verifierFlag.setVerificationNotOk();
            return false;
        }
        return false;
    }
}

