/*
 * Decompiled with CFR 0.152.
 */
package hvlnoise;

import Jama.Matrix;
import hvlnoise.ElectricalSystem;
import hvlnoise.HighVoltageLine;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.JProgressBar;

public class ElectricField
implements Serializable {
    private HighVoltageLine hvl;
    private transient JProgressBar calculationProgressBar;
    private int numberOfContourPoints;
    private ArrayList<Matrix> contourPoints;
    private ArrayList<int[]> indicesOfSubconductorContourPoints;
    private ArrayList<Matrix> chargePoints;
    private Hashtable<String, Integer> indexTransformationTable;
    private Matrix inversePotentialCoefficients;
    private int[] numberOfPotentialCoefficientsA;
    private double[] chargeCoefficientsA;
    private int[] numberOfPotentialCoefficientsB;
    private double[] chargeCoefficientsB;
    private int[] numberOfPotentialCoefficientsC;
    private double[] chargeCoefficientsC;
    private int[] numberOfPotentialCoefficientsD;
    private double[] chargeCoefficientsD;
    private int[] numberOfPotentialCoefficientsE;
    private int[] numberOfPotentialCoefficientsF;
    private double[] chargeCoefficientsE;
    private ArrayList<double[]> rmsFieldOfSubconductors;
    private final double EPSILON0 = 8.854E-12;

    public ElectricField(HighVoltageLine hvl, double calculationAccuracy, JProgressBar calculationProgressBar) {
        this.hvl = hvl;
        this.calculationProgressBar = calculationProgressBar;
        this.numberOfContourPoints = (int)Math.round(Math.PI / Math.acos(1.0 - calculationAccuracy));
        this.setContourPointsAndChargePoints();
        this.buildPotentialCoefficientsMatrix();
    }

    public void calculateElectricField() {
        this.calculateChargeCoefficients();
        this.calculateRmsFieldOfSubconductors();
    }

    public double getMaximumRmsFieldOfSubconductor(int subconductorIndex) {
        double maximumFieldValue = 0.0;
        for (int i = 0; i < this.rmsFieldOfSubconductors.get(subconductorIndex).length; ++i) {
            double currentFieldValue = this.rmsFieldOfSubconductors.get(subconductorIndex)[i];
            if (!(currentFieldValue > maximumFieldValue)) continue;
            maximumFieldValue = currentFieldValue;
        }
        return maximumFieldValue;
    }

    public double getAverageRmsFieldOfSubconductor(int subconductorIndex) {
        int numberOfFieldValues = this.rmsFieldOfSubconductors.get(subconductorIndex).length;
        double sumOfFieldValues = 0.0;
        for (int i = 0; i < numberOfFieldValues; ++i) {
            sumOfFieldValues += this.rmsFieldOfSubconductors.get(subconductorIndex)[i];
        }
        return sumOfFieldValues / (double)numberOfFieldValues;
    }

    public double[] getRmsFieldOfSubconductor(int systemIndex, int conductorIndex, int subconductorIndex) {
        int overallSubconductorIndex = this.indexTransformationTable.get("ES" + String.valueOf(systemIndex) + "Ph" + String.valueOf(conductorIndex) + "SC" + String.valueOf(subconductorIndex));
        return this.rmsFieldOfSubconductors.get(overallSubconductorIndex);
    }

    private void setContourPointsAndChargePoints() {
        this.contourPoints = new ArrayList();
        this.indicesOfSubconductorContourPoints = new ArrayList();
        this.chargePoints = new ArrayList();
        this.indexTransformationTable = new Hashtable();
        int overallSubconductorIndex = 0;
        ElectricalSystem[] acThreePhaseSystems = this.hvl.getAcThreePhaseSystems();
        int[] acThreePhaseSystemIndices = this.hvl.getAcThreePhaseSystemIndices();
        int numberOfAcThreePhaseSystems = acThreePhaseSystems.length;
        this.numberOfPotentialCoefficientsA = new int[numberOfAcThreePhaseSystems];
        this.numberOfPotentialCoefficientsB = new int[numberOfAcThreePhaseSystems];
        this.numberOfPotentialCoefficientsC = new int[numberOfAcThreePhaseSystems];
        for (int phaseIndex = 0; phaseIndex < 3; ++phaseIndex) {
            for (int i = 0; i < numberOfAcThreePhaseSystems; ++i) {
                ElectricalSystem system = acThreePhaseSystems[i];
                int numberOfSubconductors = system.getNumberOfSubconductors();
                for (int j = 0; j < numberOfSubconductors; ++j) {
                    this.setContourPointsAndChargePointsOfSubconductor(system, phaseIndex, j);
                    if (phaseIndex == 0) {
                        int n = i;
                        this.numberOfPotentialCoefficientsA[n] = this.numberOfPotentialCoefficientsA[n] + this.numberOfContourPoints;
                    } else if (phaseIndex == 1) {
                        int n = i;
                        this.numberOfPotentialCoefficientsB[n] = this.numberOfPotentialCoefficientsB[n] + this.numberOfContourPoints;
                    } else {
                        int n = i;
                        this.numberOfPotentialCoefficientsC[n] = this.numberOfPotentialCoefficientsC[n] + this.numberOfContourPoints;
                    }
                    this.indexTransformationTable.put("ES" + String.valueOf(acThreePhaseSystemIndices[i]) + "Ph" + String.valueOf(phaseIndex) + "SC" + String.valueOf(j), overallSubconductorIndex);
                    ++overallSubconductorIndex;
                }
            }
        }
        ElectricalSystem[] acSinglePhaseSystems = this.hvl.getAcSinglePhaseSystems();
        int[] acSinglePhaseSystemIndices = this.hvl.getAcSinglePhaseSystemIndices();
        int numberOfAcSinglePhaseSystems = acSinglePhaseSystems.length;
        this.numberOfPotentialCoefficientsD = new int[numberOfAcSinglePhaseSystems];
        for (int i = 0; i < numberOfAcSinglePhaseSystems; ++i) {
            ElectricalSystem system = acSinglePhaseSystems[i];
            int numberOfSubconductors = system.getNumberOfSubconductors();
            for (int j = 0; j < numberOfSubconductors; ++j) {
                this.setContourPointsAndChargePointsOfSubconductor(system, 0, j);
                int n = i;
                this.numberOfPotentialCoefficientsD[n] = this.numberOfPotentialCoefficientsD[n] + this.numberOfContourPoints;
                this.indexTransformationTable.put("ES" + String.valueOf(acSinglePhaseSystemIndices[i]) + "Ph" + String.valueOf(0) + "SC" + String.valueOf(j), overallSubconductorIndex);
                ++overallSubconductorIndex;
            }
        }
        ElectricalSystem[] dcTwoPhaseSystems = this.hvl.getDcTwoPhaseSystems();
        int[] dcTwoPhaseSystemIndices = this.hvl.getDcTwoPhaseSystemIndices();
        int numberOfDcTwoPhaseSystems = dcTwoPhaseSystems.length;
        this.numberOfPotentialCoefficientsE = new int[numberOfDcTwoPhaseSystems];
        this.numberOfPotentialCoefficientsF = new int[numberOfDcTwoPhaseSystems];
        for (int phaseIndex = 0; phaseIndex < 2; ++phaseIndex) {
            for (int i = 0; i < numberOfDcTwoPhaseSystems; ++i) {
                ElectricalSystem system = dcTwoPhaseSystems[i];
                int numberOfSubconductors = system.getNumberOfSubconductors();
                for (int j = 0; j < numberOfSubconductors; ++j) {
                    this.setContourPointsAndChargePointsOfSubconductor(system, phaseIndex, j);
                    if (phaseIndex == 0) {
                        int n = i;
                        this.numberOfPotentialCoefficientsE[n] = this.numberOfPotentialCoefficientsE[n] + this.numberOfContourPoints;
                    } else {
                        int n = i;
                        this.numberOfPotentialCoefficientsF[n] = this.numberOfPotentialCoefficientsF[n] + this.numberOfContourPoints;
                    }
                    this.indexTransformationTable.put("ES" + String.valueOf(dcTwoPhaseSystemIndices[i]) + "Ph" + String.valueOf(phaseIndex) + "SC" + String.valueOf(j), overallSubconductorIndex);
                    ++overallSubconductorIndex;
                }
            }
        }
        this.calculationProgressBar.setValue(10);
    }

    private void setContourPointsAndChargePointsOfSubconductor(ElectricalSystem system, int conductorIndex, int subconductorIndex) {
        Matrix subconductorPosition = system.getSubconductorAbsolutePosition(conductorIndex, subconductorIndex);
        double subconductorRadius = system.getSubconductorRadius(subconductorIndex) / 1000.0;
        double chargePointRadius = subconductorRadius / (1.0 + 2.0 * Math.sin(Math.PI / (double)this.numberOfContourPoints));
        int[] contourPointIndices = new int[2];
        contourPointIndices[0] = this.contourPoints.size();
        for (int m = 0; m < this.numberOfContourPoints; ++m) {
            double[][] contourPoint = new double[][]{{subconductorRadius * Math.cos(Math.PI * 2 / (double)this.numberOfContourPoints * (double)m)}, {subconductorRadius * Math.sin(Math.PI * 2 / (double)this.numberOfContourPoints * (double)m)}};
            this.contourPoints.add(subconductorPosition.plus(new Matrix((double[][])contourPoint)));
            double[][] chargePoint = new double[][]{{chargePointRadius * Math.cos(Math.PI * 2 / (double)this.numberOfContourPoints * (double)m)}, {chargePointRadius * Math.sin(Math.PI * 2 / (double)this.numberOfContourPoints * (double)m)}};
            this.chargePoints.add(subconductorPosition.plus(new Matrix((double[][])chargePoint)));
        }
        contourPointIndices[1] = this.contourPoints.size() - 1;
        this.indicesOfSubconductorContourPoints.add(contourPointIndices);
    }

    private void buildPotentialCoefficientsMatrix() {
        int totalNumberOfContourPoints = this.contourPoints.size();
        int totalNumberOfChargePoints = this.chargePoints.size();
        Matrix potentialCoefficients = new Matrix(totalNumberOfContourPoints, totalNumberOfChargePoints);
        for (int u = 0; u < totalNumberOfContourPoints; ++u) {
            Matrix contourPointPosition = this.contourPoints.get(u);
            for (int v = 0; v < totalNumberOfChargePoints; ++v) {
                Matrix chargePointPosition = this.chargePoints.get(v);
                Matrix mirrorChargePointPosition = new Matrix(2, 1);
                mirrorChargePointPosition.set(0, 0, chargePointPosition.get(0, 0));
                mirrorChargePointPosition.set(1, 0, -chargePointPosition.get(1, 0));
                double distance_ContourPoint_MirrorChargePoint = contourPointPosition.minus(mirrorChargePointPosition).norm2();
                double distance_ContourPoint_ChargePoint = contourPointPosition.minus(chargePointPosition).norm2();
                double p_uv = Math.log(distance_ContourPoint_MirrorChargePoint / distance_ContourPoint_ChargePoint) / 5.563132270976805E-11;
                potentialCoefficients.set(u, v, p_uv);
            }
        }
        this.calculationProgressBar.setValue(23);
        this.inversePotentialCoefficients = potentialCoefficients.inverse();
        this.calculationProgressBar.setValue(46);
    }

    private void calculateChargeCoefficients() {
        int numberOfChargePoints = this.chargePoints.size();
        this.chargeCoefficientsA = new double[numberOfChargePoints];
        this.chargeCoefficientsB = new double[numberOfChargePoints];
        this.chargeCoefficientsC = new double[numberOfChargePoints];
        this.chargeCoefficientsD = new double[numberOfChargePoints];
        this.chargeCoefficientsE = new double[numberOfChargePoints];
        for (int i = 0; i < numberOfChargePoints; ++i) {
            double systemVoltage;
            Matrix potentialCoefficients;
            int j;
            int columnPointer = 0;
            for (j = 0; j < this.numberOfPotentialCoefficientsA.length; ++j) {
                potentialCoefficients = this.inversePotentialCoefficients.getMatrix(i, i, columnPointer, columnPointer + this.numberOfPotentialCoefficientsA[j] - 1);
                columnPointer += this.numberOfPotentialCoefficientsA[j];
                systemVoltage = Math.sqrt(0.6666666666666666) * this.hvl.getAcThreePhaseSystems()[j].getACSystemVoltage() * 1000.0;
                int n = i;
                this.chargeCoefficientsA[n] = this.chargeCoefficientsA[n] + new Matrix(potentialCoefficients.getColumnDimension(), 1, 1.0).times(potentialCoefficients).trace() * systemVoltage;
            }
            for (j = 0; j < this.numberOfPotentialCoefficientsB.length; ++j) {
                potentialCoefficients = this.inversePotentialCoefficients.getMatrix(i, i, columnPointer, columnPointer + this.numberOfPotentialCoefficientsB[j] - 1);
                columnPointer += this.numberOfPotentialCoefficientsB[j];
                systemVoltage = Math.sqrt(0.6666666666666666) * this.hvl.getAcThreePhaseSystems()[j].getACSystemVoltage() * 1000.0;
                int n = i;
                this.chargeCoefficientsB[n] = this.chargeCoefficientsB[n] + new Matrix(potentialCoefficients.getColumnDimension(), 1, 1.0).times(potentialCoefficients).trace() * systemVoltage;
            }
            for (j = 0; j < this.numberOfPotentialCoefficientsC.length; ++j) {
                potentialCoefficients = this.inversePotentialCoefficients.getMatrix(i, i, columnPointer, columnPointer + this.numberOfPotentialCoefficientsC[j] - 1);
                columnPointer += this.numberOfPotentialCoefficientsC[j];
                systemVoltage = Math.sqrt(0.6666666666666666) * this.hvl.getAcThreePhaseSystems()[j].getACSystemVoltage() * 1000.0;
                int n = i;
                this.chargeCoefficientsC[n] = this.chargeCoefficientsC[n] + new Matrix(potentialCoefficients.getColumnDimension(), 1, 1.0).times(potentialCoefficients).trace() * systemVoltage;
            }
            for (j = 0; j < this.numberOfPotentialCoefficientsD.length; ++j) {
                potentialCoefficients = this.inversePotentialCoefficients.getMatrix(i, i, columnPointer, columnPointer + this.numberOfPotentialCoefficientsD[j] - 1);
                columnPointer += this.numberOfPotentialCoefficientsD[j];
                systemVoltage = Math.sqrt(2.0) * this.hvl.getAcSinglePhaseSystems()[j].getACSystemVoltage() * 1000.0;
                int n = i;
                this.chargeCoefficientsD[n] = this.chargeCoefficientsD[n] + new Matrix(potentialCoefficients.getColumnDimension(), 1, 1.0).times(potentialCoefficients).trace() * systemVoltage;
            }
            for (j = 0; j < this.numberOfPotentialCoefficientsE.length; ++j) {
                potentialCoefficients = this.inversePotentialCoefficients.getMatrix(i, i, columnPointer, columnPointer + this.numberOfPotentialCoefficientsE[j] - 1);
                columnPointer += this.numberOfPotentialCoefficientsE[j];
                systemVoltage = this.hvl.getDcTwoPhaseSystems()[j].getDCSystemVoltage(0) * 1000.0;
                int n = i;
                this.chargeCoefficientsE[n] = this.chargeCoefficientsE[n] + new Matrix(potentialCoefficients.getColumnDimension(), 1, 1.0).times(potentialCoefficients).trace() * systemVoltage;
            }
            for (j = 0; j < this.numberOfPotentialCoefficientsF.length; ++j) {
                potentialCoefficients = this.inversePotentialCoefficients.getMatrix(i, i, columnPointer, columnPointer + this.numberOfPotentialCoefficientsF[j] - 1);
                columnPointer += this.numberOfPotentialCoefficientsF[j];
                systemVoltage = this.hvl.getDcTwoPhaseSystems()[j].getDCSystemVoltage(1) * 1000.0;
                int n = i;
                this.chargeCoefficientsE[n] = this.chargeCoefficientsE[n] + new Matrix(potentialCoefficients.getColumnDimension(), 1, 1.0).times(potentialCoefficients).trace() * systemVoltage;
            }
        }
        this.calculationProgressBar.setValue(58);
    }

    private void calculateRmsFieldOfSubconductors() {
        this.rmsFieldOfSubconductors = new ArrayList();
        int numberOfSubconductors = this.indicesOfSubconductorContourPoints.size();
        for (int i = 0; i < numberOfSubconductors; ++i) {
            double[] rmsFieldAtContourPoints = new double[this.numberOfContourPoints];
            int startingIndex = this.indicesOfSubconductorContourPoints.get(i)[0];
            int endingIndex = this.indicesOfSubconductorContourPoints.get(i)[1];
            for (int k = startingIndex; k <= endingIndex; ++k) {
                double rmsField;
                rmsFieldAtContourPoints[k - startingIndex] = rmsField = this.calculateRmsFieldAtContourPoint(k);
            }
            this.rmsFieldOfSubconductors.add(rmsFieldAtContourPoints);
            int step = (int)Math.round(42.0 / (double)numberOfSubconductors);
            if (step == 0) {
                step = 1;
            }
            if (!(42.0 / (double)numberOfSubconductors * (double)(i + 1) >= (double)(this.calculationProgressBar.getValue() - 58))) continue;
            this.calculationProgressBar.setValue(this.calculationProgressBar.getValue() + step);
        }
    }

    private double calculateRmsFieldAtContourPoint(int contourPointIndex) {
        Matrix[] fieldDirectionVectors = this.getFieldDirectionVectors(contourPointIndex);
        Matrix[] fieldVectors = this.getFieldVectors(fieldDirectionVectors);
        Matrix rmsFieldVector = new Matrix(2, 1);
        for (int i = 0; i < 2; ++i) {
            double fv1 = fieldVectors[0].get(i, 0);
            double fv2 = fieldVectors[1].get(i, 0);
            double fv3 = fieldVectors[2].get(i, 0);
            double fv4 = fieldVectors[3].get(i, 0);
            double fv5 = fieldVectors[4].get(i, 0);
            rmsFieldVector.set(i, 0, Math.sqrt(0.5 * (Math.pow(fv1, 2.0) - fv1 * (fv2 + fv3) + Math.pow(fv2, 2.0) - fv2 * fv3 + Math.pow(fv3, 2.0) + Math.pow(fv4, 2.0) + 2.0 * Math.pow(fv5, 2.0))));
        }
        double rmsField = rmsFieldVector.norm2();
        return rmsField * 1.0E-5;
    }

    private Matrix[] getFieldDirectionVectors(int contourPointIndex) {
        Matrix contourPointPosition = this.contourPoints.get(contourPointIndex);
        int numberOfChargePoints = this.chargePoints.size();
        Matrix[] fieldDirectionVectors = new Matrix[numberOfChargePoints];
        for (int i = 0; i < numberOfChargePoints; ++i) {
            Matrix chargePointPosition = this.chargePoints.get(i);
            Matrix mirrorChargePointPosition = new Matrix(2, 1);
            mirrorChargePointPosition.set(0, 0, chargePointPosition.get(0, 0));
            mirrorChargePointPosition.set(1, 0, -chargePointPosition.get(1, 0));
            Matrix direction_ContourPoint_ChargePoint = contourPointPosition.minus(chargePointPosition);
            double distance_ContourPoint_ChargePoint = direction_ContourPoint_ChargePoint.norm2();
            Matrix direction_ContourPoint_MirrorChargePoint = contourPointPosition.minus(mirrorChargePointPosition);
            double distance_ContourPoint_MirrorChargePoint = direction_ContourPoint_MirrorChargePoint.norm2();
            Matrix directionVector1 = direction_ContourPoint_ChargePoint.times(1.0 / Math.pow(distance_ContourPoint_ChargePoint, 2.0));
            Matrix directionVector2 = direction_ContourPoint_MirrorChargePoint.times(1.0 / Math.pow(distance_ContourPoint_MirrorChargePoint, 2.0));
            fieldDirectionVectors[i] = directionVector1.minus(directionVector2);
        }
        return fieldDirectionVectors;
    }

    private Matrix[] getFieldVectors(Matrix[] fieldDirectionVectors) {
        int numberOfChargePoints = this.chargePoints.size();
        Matrix[] fieldVectors = new Matrix[5];
        for (int k = 0; k < fieldVectors.length; ++k) {
            fieldVectors[k] = new Matrix(2, 1);
        }
        for (int i = 0; i < numberOfChargePoints; ++i) {
            fieldVectors[0] = fieldVectors[0].plus(fieldDirectionVectors[i].times(this.chargeCoefficientsA[i]));
            fieldVectors[1] = fieldVectors[1].plus(fieldDirectionVectors[i].times(this.chargeCoefficientsB[i]));
            fieldVectors[2] = fieldVectors[2].plus(fieldDirectionVectors[i].times(this.chargeCoefficientsC[i]));
            fieldVectors[3] = fieldVectors[3].plus(fieldDirectionVectors[i].times(this.chargeCoefficientsD[i]));
            fieldVectors[4] = fieldVectors[4].plus(fieldDirectionVectors[i].times(this.chargeCoefficientsE[i]));
        }
        double fieldFactor = 1.0 / (Math.PI * 2 * this.EPSILON0);
        for (int j = 0; j < fieldVectors.length; ++j) {
            fieldVectors[j] = fieldVectors[j].times(fieldFactor);
        }
        return fieldVectors;
    }
}

