/*
 * Decompiled with CFR 0.152.
 */
package hvlnoise;

import Jama.Matrix;
import hvlnoise.Conductor;
import hvlnoise.SystemType;
import java.io.Serializable;

public class ElectricalSystem
implements Serializable {
    private SystemType systemType;
    private double acSystemVoltage;
    private double[] dcSystemVoltage;
    private Conductor[] conductors;
    private boolean subconductorNormalModeEnabled;
    private double[] subconductorNormalModeParameters;

    public void createAcThreePhaseSystem(double acSystemVoltage, Matrix conductorPositions, Matrix relSubconductorPositions, Matrix subconductorRadii, boolean subconductorNormalModeEnabled, double[] subconductorNormalModeParameters) {
        if (this.systemType == null) {
            this.systemType = SystemType.AC_THREE_PHASE_SYSTEM;
            this.acSystemVoltage = acSystemVoltage;
            int numberOfConductors = 3;
            this.conductors = new Conductor[numberOfConductors];
            for (int i = 0; i < numberOfConductors; ++i) {
                this.conductors[i] = new Conductor(conductorPositions.getMatrix(0, 1, i, i), relSubconductorPositions, subconductorRadii);
            }
            this.subconductorNormalModeEnabled = subconductorNormalModeEnabled;
            this.subconductorNormalModeParameters = subconductorNormalModeParameters;
        }
    }

    public void createAcSinglePhaseSystem(double acSystemVoltage, Matrix conductorPosition, Matrix relSubconductorPositions, Matrix subconductorRadii, boolean subconductorNormalModeEnabled, double[] subconductorNormalModeParameters) {
        if (this.systemType == null) {
            this.systemType = SystemType.AC_SINGLE_PHASE_SYSTEM;
            this.acSystemVoltage = acSystemVoltage;
            this.conductors = new Conductor[1];
            this.conductors[0] = new Conductor(conductorPosition, relSubconductorPositions, subconductorRadii);
            this.subconductorNormalModeEnabled = subconductorNormalModeEnabled;
            this.subconductorNormalModeParameters = subconductorNormalModeParameters;
        }
    }

    public void createDcTwoPhaseSystem(double[] dcSystemVoltage, Matrix conductorPositions, Matrix relSubconductorPositions, Matrix subconductorRadii, boolean subconductorNormalModeEnabled, double[] subconductorNormalModeParameters) {
        if (this.systemType == null) {
            this.systemType = SystemType.DC_TWO_PHASE_SYSTEM;
            this.dcSystemVoltage = dcSystemVoltage;
            int numberOfConductors = 2;
            this.conductors = new Conductor[numberOfConductors];
            for (int i = 0; i < numberOfConductors; ++i) {
                this.conductors[i] = new Conductor(conductorPositions.getMatrix(0, 1, i, i), relSubconductorPositions, subconductorRadii);
            }
            this.subconductorNormalModeEnabled = subconductorNormalModeEnabled;
            this.subconductorNormalModeParameters = subconductorNormalModeParameters;
        }
    }

    public SystemType getSystemType() {
        return this.systemType;
    }

    public double getACSystemVoltage() {
        return this.acSystemVoltage;
    }

    public double getDCSystemVoltage(int conductorIndex) {
        return this.dcSystemVoltage[conductorIndex];
    }

    public int getNumberOfConductors() {
        return this.conductors.length;
    }

    public int getNumberOfSubconductors() {
        return this.conductors[0].getNumberOfSubconductors();
    }

    public double getConductorAbsolutePositionX(int conductorIndex) {
        return this.conductors[conductorIndex].getAbsolutePositionX();
    }

    public double getConductorAbsolutePositionY(int conductorIndex) {
        return this.conductors[conductorIndex].getAbsolutePositionY();
    }

    public Matrix getConductorAbsolutePosition(int conductorIndex) {
        return this.conductors[conductorIndex].getAbsolutePosition();
    }

    public double getSubconductorAbsolutePositionX(int conductorIndex, int subconductorIndex) {
        return this.conductors[conductorIndex].getSubconductorAbsolutePositionX(subconductorIndex);
    }

    public double getSubconductorAbsolutePositionY(int conductorIndex, int subconductorIndex) {
        return this.conductors[conductorIndex].getSubconductorAbsolutePositionY(subconductorIndex);
    }

    public Matrix getSubconductorAbsolutePosition(int conductorIndex, int subconductorIndex) {
        return this.conductors[conductorIndex].getSubconductorAbsolutePosition(subconductorIndex);
    }

    public double getSubconductorRelativePositionX(int subconductorIndex) {
        return this.conductors[0].getSubconductorRelativePositionX(subconductorIndex);
    }

    public double getSubconductorRelativePositionY(int subconductorIndex) {
        return this.conductors[0].getSubconductorRelativePositionY(subconductorIndex);
    }

    public double getSubconductorRadius(int subconductorIndex) {
        return this.conductors[0].getSubconductorRadius(subconductorIndex);
    }

    public boolean isSubconductorNormalModeEnabled() {
        return this.subconductorNormalModeEnabled;
    }

    public double getSubconductorNormalModeParameter(int parameterIndex) {
        return this.subconductorNormalModeParameters[parameterIndex];
    }
}

