/*
 * Decompiled with CFR 0.152.
 */
package hvlnoise;

import Jama.Matrix;
import hvlnoise.DecimalNumberVerifier;
import hvlnoise.DecimalNumberVerifierFlag;
import hvlnoise.DecimalNumberVerifierType;
import hvlnoise.ElectricalSystem;
import hvlnoise.HVLNoiseApp;
import hvlnoise.HighVoltageLine;
import hvlnoise.SystemType;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ResourceMap;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.annotations.XYTextAnnotation;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYBubbleRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.DefaultXYZDataset;
import org.jfree.data.xy.XYZDataset;

public class HVLNoiseSystemProperties
extends JDialog {
    private JFreeChart chart;
    private DefaultXYZDataset xyzDataset;
    private XYBubbleRenderer bubbleRenderer;
    private HighVoltageLine hvl;
    private ElectricalSystem system;
    private int systemIndex;
    double[][] xyrDataOfSubconductorsInNormalMode;
    double[][] xyrDataOfSubconductorsInExpertMode;
    private boolean saveButtonClicked;
    private DecimalNumberVerifierFlag verifierFlag = new DecimalNumberVerifierFlag();
    private DecimalNumberVerifierFlag verifierFlagExpertMode = new DecimalNumberVerifierFlag();
    private JRadioButton acSinglePhaseSystem;
    private JRadioButton acThreePhaseSystem;
    private JTextField bundleDiameter;
    private JTextField bundlePlacementStartingAngle;
    private JTextField conductor1X;
    private JTextField conductor1Y;
    private JTextField conductor2X;
    private JTextField conductor2Y;
    private JTextField conductor3X;
    private JTextField conductor3Y;
    private JPanel conductors;
    private JRadioButton dcTwoPhaseSystem;
    private JPanel electricalSystem;
    private JTextField frequencyACSinglePhaseSystem;
    private JTextField frequencyACThreePhaseSystem;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel18;
    private JLabel jLabel19;
    private JLabel jLabel2;
    private JLabel jLabel20;
    private JLabel jLabel21;
    private JLabel jLabel22;
    private JLabel jLabel23;
    private JLabel jLabel24;
    private JLabel jLabel25;
    private JLabel jLabel26;
    private JLabel jLabel27;
    private JLabel jLabel28;
    private JLabel jLabel29;
    private JLabel jLabel3;
    private JLabel jLabel30;
    private JLabel jLabel31;
    private JLabel jLabel32;
    private JLabel jLabel33;
    private JLabel jLabel34;
    private JLabel jLabel35;
    private JLabel jLabel36;
    private JLabel jLabel37;
    private JLabel jLabel38;
    private JLabel jLabel39;
    private JLabel jLabel4;
    private JLabel jLabel40;
    private JLabel jLabel41;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JSpinner numberOfSubconductors;
    private JButton removeSubconductorButton;
    private JButton saveButton;
    private JButton saveSubconductorButton;
    private JPanel subconductorChart;
    private JTextField subconductorDiameterExpert;
    private JTextField subconductorDiameterNormal;
    private JPanel subconductorExpertMode;
    private DefaultListModel subconductorListModel;
    private JList subconductorList;
    private JTabbedPane subconductorMode;
    private JPanel subconductorNormalMode;
    private JScrollPane subconductorScrollPane;
    private JTextField subconductorX;
    private JTextField subconductorY;
    private JPanel subconductors;
    private ButtonGroup systemGroup;
    private JTextField voltage1DcTwoPhaseSystem;
    private JTextField voltage2DcTwoPhaseSystem;
    private JTextField voltageACThreePhaseSystem;
    private JTextField voltageAcSinglePhaseSystem;

    public HVLNoiseSystemProperties(Frame parent, HighVoltageLine hvl, ElectricalSystem system) {
        super(parent);
        this.initChart();
        this.initComponents();
        this.hvl = hvl;
        this.system = system;
        this.systemIndex = this.hvl.getSystemIndex(this.system);
        if (this.system != null) {
            this.setComponents();
        }
        this.saveButtonClicked = false;
    }

    public boolean wasSaveButtonClicked() {
        return this.saveButtonClicked;
    }

    private void initChart() {
        this.xyzDataset = new DefaultXYZDataset();
        this.bubbleRenderer = new XYBubbleRenderer(1);
        this.chart = ChartFactory.createBubbleChart(null, (String)"x [mm]", (String)"y [mm]", (XYZDataset)this.xyzDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
        XYPlot plot = this.chart.getXYPlot();
        plot.setBackgroundPaint((Paint)Color.white);
        plot.setDomainGridlinePaint((Paint)Color.black);
        plot.setRangeGridlinePaint((Paint)Color.black);
        plot.setOutlinePaint((Paint)Color.black);
    }

    private void setComponents() {
        SystemType sysType = this.system.getSystemType();
        if (sysType == SystemType.AC_THREE_PHASE_SYSTEM) {
            this.acThreePhaseSystem.setSelected(true);
            this.acSinglePhaseSystem.setSelected(false);
            this.dcTwoPhaseSystem.setSelected(false);
            this.acSinglePhaseSystem.setEnabled(false);
            this.dcTwoPhaseSystem.setEnabled(false);
            this.voltageACThreePhaseSystem.setEnabled(true);
            this.voltageAcSinglePhaseSystem.setEnabled(false);
            this.voltage1DcTwoPhaseSystem.setEnabled(false);
            this.voltage2DcTwoPhaseSystem.setEnabled(false);
            this.conductor1X.setEnabled(true);
            this.conductor2X.setEnabled(true);
            this.conductor3X.setEnabled(true);
            this.conductor1Y.setEnabled(true);
            this.conductor2Y.setEnabled(true);
            this.conductor3Y.setEnabled(true);
            this.voltageACThreePhaseSystem.setText(String.valueOf(this.system.getACSystemVoltage()));
            this.conductor1X.setText(String.valueOf(this.system.getConductorAbsolutePositionX(0)));
            this.conductor2X.setText(String.valueOf(this.system.getConductorAbsolutePositionX(1)));
            this.conductor3X.setText(String.valueOf(this.system.getConductorAbsolutePositionX(2)));
            this.conductor1Y.setText(String.valueOf(this.system.getConductorAbsolutePositionY(0)));
            this.conductor2Y.setText(String.valueOf(this.system.getConductorAbsolutePositionY(1)));
            this.conductor3Y.setText(String.valueOf(this.system.getConductorAbsolutePositionY(2)));
        }
        if (sysType == SystemType.AC_SINGLE_PHASE_SYSTEM) {
            this.acThreePhaseSystem.setSelected(false);
            this.acSinglePhaseSystem.setSelected(true);
            this.dcTwoPhaseSystem.setSelected(false);
            this.acThreePhaseSystem.setEnabled(false);
            this.dcTwoPhaseSystem.setEnabled(false);
            this.voltageACThreePhaseSystem.setEnabled(false);
            this.voltageAcSinglePhaseSystem.setEnabled(true);
            this.voltage1DcTwoPhaseSystem.setEnabled(false);
            this.voltage2DcTwoPhaseSystem.setEnabled(false);
            this.conductor1X.setEnabled(true);
            this.conductor2X.setEnabled(false);
            this.conductor3X.setEnabled(false);
            this.conductor1Y.setEnabled(true);
            this.conductor2Y.setEnabled(false);
            this.conductor3Y.setEnabled(false);
            this.voltageAcSinglePhaseSystem.setText(String.valueOf(this.system.getACSystemVoltage()));
            this.conductor1X.setText(String.valueOf(this.system.getConductorAbsolutePositionX(0)));
            this.conductor1Y.setText(String.valueOf(this.system.getConductorAbsolutePositionY(0)));
        }
        if (sysType == SystemType.DC_TWO_PHASE_SYSTEM) {
            this.acThreePhaseSystem.setSelected(false);
            this.acSinglePhaseSystem.setSelected(false);
            this.dcTwoPhaseSystem.setSelected(true);
            this.acThreePhaseSystem.setEnabled(false);
            this.acSinglePhaseSystem.setEnabled(false);
            this.voltageACThreePhaseSystem.setEnabled(false);
            this.voltageAcSinglePhaseSystem.setEnabled(false);
            this.voltage1DcTwoPhaseSystem.setEnabled(true);
            this.voltage2DcTwoPhaseSystem.setEnabled(true);
            this.conductor1X.setEnabled(true);
            this.conductor2X.setEnabled(true);
            this.conductor3X.setEnabled(false);
            this.conductor1Y.setEnabled(true);
            this.conductor2Y.setEnabled(true);
            this.conductor3Y.setEnabled(false);
            this.voltage1DcTwoPhaseSystem.setText(String.valueOf(this.system.getDCSystemVoltage(0)));
            this.voltage2DcTwoPhaseSystem.setText(String.valueOf(this.system.getDCSystemVoltage(1)));
            this.conductor1X.setText(String.valueOf(this.system.getConductorAbsolutePositionX(0)));
            this.conductor2X.setText(String.valueOf(this.system.getConductorAbsolutePositionX(1)));
            this.conductor1Y.setText(String.valueOf(this.system.getConductorAbsolutePositionY(0)));
            this.conductor2Y.setText(String.valueOf(this.system.getConductorAbsolutePositionY(1)));
        }
        if (this.system.isSubconductorNormalModeEnabled()) {
            this.subconductorMode.setSelectedIndex(0);
            this.numberOfSubconductors.getModel().setValue(this.system.getNumberOfSubconductors());
            this.subconductorDiameterNormal.setText(String.valueOf(this.system.getSubconductorRadius(0) * 2.0));
            this.bundleDiameter.setText(String.valueOf(this.system.getSubconductorNormalModeParameter(0)));
            this.bundlePlacementStartingAngle.setText(String.valueOf(this.system.getSubconductorNormalModeParameter(1)));
            this.setSubconductorDataInNormalMode();
        } else {
            this.subconductorMode.setSelectedIndex(1);
            int numOfSubconductors = this.system.getNumberOfSubconductors();
            this.subconductorListModel.removeAllElements();
            this.subconductorListModel.add(0, "New Subconductor");
            for (int i = 0; i < numOfSubconductors; ++i) {
                this.subconductorListModel.add(i + 1, "SC" + String.valueOf(i + 1) + " (" + "x=" + String.valueOf(this.system.getSubconductorRelativePositionX(i)) + "mm " + "y=" + String.valueOf(this.system.getSubconductorRelativePositionY(i)) + "mm " + "d=" + String.valueOf(this.system.getSubconductorRadius(i) * 2.0) + "mm)");
            }
            this.setSubconductorDataInExpertMode();
            this.subconductorList.setSelectedIndex(0);
            this.subconductorList.ensureIndexIsVisible(0);
        }
    }

    private void onElectricalSystemChange() {
        if (this.acThreePhaseSystem.isSelected()) {
            this.voltageACThreePhaseSystem.setEnabled(true);
            this.voltageAcSinglePhaseSystem.setEnabled(false);
            this.voltage1DcTwoPhaseSystem.setEnabled(false);
            this.voltage2DcTwoPhaseSystem.setEnabled(false);
            this.conductor1X.setEnabled(true);
            this.conductor2X.setEnabled(true);
            this.conductor3X.setEnabled(true);
            this.conductor1Y.setEnabled(true);
            this.conductor2Y.setEnabled(true);
            this.conductor3Y.setEnabled(true);
        }
        if (this.acSinglePhaseSystem.isSelected()) {
            this.voltageACThreePhaseSystem.setEnabled(false);
            this.voltageAcSinglePhaseSystem.setEnabled(true);
            this.voltage1DcTwoPhaseSystem.setEnabled(false);
            this.voltage2DcTwoPhaseSystem.setEnabled(false);
            this.conductor1X.setEnabled(true);
            this.conductor2X.setEnabled(false);
            this.conductor3X.setEnabled(false);
            this.conductor1Y.setEnabled(true);
            this.conductor2Y.setEnabled(false);
            this.conductor3Y.setEnabled(false);
        }
        if (this.dcTwoPhaseSystem.isSelected()) {
            this.voltageACThreePhaseSystem.setEnabled(false);
            this.voltageAcSinglePhaseSystem.setEnabled(false);
            this.voltage1DcTwoPhaseSystem.setEnabled(true);
            this.voltage2DcTwoPhaseSystem.setEnabled(true);
            this.conductor1X.setEnabled(true);
            this.conductor2X.setEnabled(true);
            this.conductor3X.setEnabled(false);
            this.conductor1Y.setEnabled(true);
            this.conductor2Y.setEnabled(true);
            this.conductor3Y.setEnabled(false);
        }
    }

    private void onSubconductorModeChange() {
        if (this.subconductorMode.getSelectedIndex() == 0) {
            this.setSubconductorDataInNormalMode();
        } else {
            this.setSubconductorDataInExpertMode();
        }
    }

    private void setSubconductorDataInNormalMode() {
        int numOfSubconductors = (Integer)this.numberOfSubconductors.getValue();
        double subconductorRadius = Double.valueOf(this.subconductorDiameterNormal.getText()) / 2.0;
        double bundleRadius = Double.valueOf(this.bundleDiameter.getText()) / 2.0;
        double startingAngle = Double.valueOf(this.bundlePlacementStartingAngle.getText()) * Math.PI / 180.0;
        this.xyrDataOfSubconductorsInNormalMode = new double[3][numOfSubconductors];
        this.bubbleRenderer.removeAnnotations();
        for (int i = 0; i < numOfSubconductors; ++i) {
            this.xyrDataOfSubconductorsInNormalMode[0][i] = bundleRadius * Math.cos(Math.PI * 2 / (double)numOfSubconductors * (double)i + startingAngle);
            this.xyrDataOfSubconductorsInNormalMode[1][i] = bundleRadius * Math.sin(Math.PI * 2 / (double)numOfSubconductors * (double)i + startingAngle);
            this.xyrDataOfSubconductorsInNormalMode[2][i] = subconductorRadius;
            XYTextAnnotation annotation = new XYTextAnnotation("SC" + String.valueOf(i + 1), this.xyrDataOfSubconductorsInNormalMode[0][i], this.xyrDataOfSubconductorsInNormalMode[1][i]);
            annotation.setFont(new Font("SansSerif", 0, 12));
            this.bubbleRenderer.addAnnotation((XYAnnotation)annotation);
        }
        this.xyzDataset.addSeries((Comparable)Integer.valueOf(0), this.xyrDataOfSubconductorsInNormalMode);
        this.bubbleRenderer.setBaseOutlinePaint((Paint)Color.lightGray);
        this.bubbleRenderer.setSeriesPaint(0, (Paint)Color.lightGray);
        this.bubbleRenderer.addAnnotation((XYAnnotation)new XYTextAnnotation("X", 0.0, 0.0));
        this.chart.getXYPlot().setRenderer((XYItemRenderer)this.bubbleRenderer);
    }

    private void setSubconductorDataInExpertMode() {
        int numOfSubconductors = this.subconductorList.getModel().getSize() - 1;
        this.xyrDataOfSubconductorsInExpertMode = new double[3][numOfSubconductors];
        this.bubbleRenderer.removeAnnotations();
        for (int i = 0; i < numOfSubconductors; ++i) {
            String listStr = (String)this.subconductorList.getModel().getElementAt(i + 1);
            Pattern pattern = Pattern.compile("=-?[0-9.]+mm");
            Matcher matcher = pattern.matcher(listStr);
            int j = 0;
            while (matcher.find()) {
                this.xyrDataOfSubconductorsInExpertMode[j][i] = Double.valueOf(listStr.substring(matcher.start() + 1, matcher.end() - 2));
                if (j == 2) {
                    double[] dArray = this.xyrDataOfSubconductorsInExpertMode[j];
                    int n = i;
                    dArray[n] = dArray[n] / 2.0;
                }
                ++j;
            }
            XYTextAnnotation annotation = new XYTextAnnotation("SC" + String.valueOf(i + 1), this.xyrDataOfSubconductorsInExpertMode[0][i], this.xyrDataOfSubconductorsInExpertMode[1][i]);
            annotation.setFont(new Font("SansSerif", 0, 12));
            this.bubbleRenderer.addAnnotation((XYAnnotation)annotation);
        }
        this.xyzDataset.addSeries((Comparable)Integer.valueOf(0), this.xyrDataOfSubconductorsInExpertMode);
        this.bubbleRenderer.setBaseOutlinePaint((Paint)Color.lightGray);
        this.bubbleRenderer.setSeriesPaint(0, (Paint)Color.lightGray);
        this.bubbleRenderer.addAnnotation((XYAnnotation)new XYTextAnnotation("X", 0.0, 0.0));
        this.chart.getXYPlot().setRenderer((XYItemRenderer)this.bubbleRenderer);
    }

    @Action
    public void saveSubconductorInExpertMode() {
        if (!this.verifierFlagExpertMode.isVerificationOk()) {
            JOptionPane.showMessageDialog(this, "Some inputs are not valid!", "Invalid inputs", 1);
            return;
        }
        if (this.subconductorX.getText().equals("") || this.subconductorY.getText().equals("") || this.subconductorDiameterExpert.getText().equals("")) {
            JOptionPane.showMessageDialog(this, "Some parameters were not specified!", "Missing parameters", 1);
            return;
        }
        if (this.subconductorList.getSelectedIndex() == 0) {
            int numberOfListItems = this.subconductorListModel.getSize();
            this.subconductorListModel.add(numberOfListItems, "SC" + String.valueOf(numberOfListItems) + " (" + "x=" + this.subconductorX.getText() + "mm " + "y=" + this.subconductorY.getText() + "mm " + "d=" + this.subconductorDiameterExpert.getText() + "mm)");
            this.subconductorList.setSelectedIndex(numberOfListItems);
            this.subconductorList.ensureIndexIsVisible(numberOfListItems);
        } else if (this.subconductorList.getSelectedIndex() != -1) {
            int subconductorIndex = this.subconductorList.getSelectedIndex();
            this.subconductorListModel.set(subconductorIndex, "SC" + String.valueOf(subconductorIndex) + " (" + "x=" + this.subconductorX.getText() + "mm " + "y=" + this.subconductorY.getText() + "mm " + "d=" + this.subconductorDiameterExpert.getText() + "mm)");
        } else {
            return;
        }
        this.setSubconductorDataInExpertMode();
    }

    @Action
    public void removeSubconductorInExpertMode() {
        if (this.subconductorList.getSelectedIndex() > 0) {
            this.subconductorListModel.remove(this.subconductorList.getSelectedIndex());
            for (int i = 1; i < this.subconductorListModel.getSize(); ++i) {
                String newListStr = ((String)this.subconductorListModel.get(i)).replaceFirst("SC[0-9]+ ", "SC" + String.valueOf(i) + " ");
                this.subconductorListModel.set(i, newListStr);
            }
            this.subconductorList.setSelectedIndex(0);
            this.subconductorList.ensureIndexIsVisible(0);
        }
        this.setSubconductorDataInExpertMode();
    }

    @Action
    public void saveLineProperties() {
        double[][] subconductorRadii;
        double[][] relSubconductorPositions;
        double[][] conductorPositions;
        double[][] xyrDataOfSubconductors;
        if (!this.verifierFlag.isVerificationOk()) {
            JOptionPane.showMessageDialog(this, "Some inputs are not valid!", "Invalid inputs", 1);
            return;
        }
        boolean subconductorNormalModeEnabled = false;
        double[] subconductorNormalModeParameters = null;
        if (this.subconductorMode.getSelectedIndex() == 0) {
            this.setSubconductorDataInNormalMode();
            xyrDataOfSubconductors = this.xyrDataOfSubconductorsInNormalMode;
            subconductorNormalModeEnabled = true;
            subconductorNormalModeParameters = new double[]{Double.valueOf(this.bundleDiameter.getText()), Double.valueOf(this.bundlePlacementStartingAngle.getText())};
        } else {
            xyrDataOfSubconductors = this.xyrDataOfSubconductorsInExpertMode;
        }
        if (this.acThreePhaseSystem.isSelected()) {
            if (this.voltageACThreePhaseSystem.getText().equals("") || this.conductor1X.getText().equals("") || this.conductor2X.getText().equals("") || this.conductor3X.getText().equals("") || this.conductor1Y.getText().equals("") || this.conductor2Y.getText().equals("") || this.conductor3Y.getText().equals("")) {
                JOptionPane.showMessageDialog(this, "Some parameters were not specified!", "Missing parameters", 1);
                return;
            }
            conductorPositions = new double[][]{{Double.valueOf(this.conductor1X.getText()), Double.valueOf(this.conductor2X.getText()), Double.valueOf(this.conductor3X.getText())}, {Double.valueOf(this.conductor1Y.getText()), Double.valueOf(this.conductor2Y.getText()), Double.valueOf(this.conductor3Y.getText())}};
            relSubconductorPositions = new double[][]{xyrDataOfSubconductors[0], xyrDataOfSubconductors[1]};
            subconductorRadii = new double[][]{xyrDataOfSubconductors[2]};
            this.hvl.addOrSetAcThreePhaseSystem(Double.valueOf(this.voltageACThreePhaseSystem.getText()), new Matrix((double[][])conductorPositions), new Matrix((double[][])relSubconductorPositions), new Matrix((double[][])subconductorRadii), subconductorNormalModeEnabled, subconductorNormalModeParameters, this.systemIndex);
        }
        if (this.acSinglePhaseSystem.isSelected()) {
            if (this.voltageAcSinglePhaseSystem.getText().equals("") || this.conductor1X.getText().equals("") || this.conductor1Y.getText().equals("")) {
                JOptionPane.showMessageDialog(this, "Some parameters were not specified!", "Missing parameters", 1);
                return;
            }
            double[][] conductorPosition = new double[][]{{Double.valueOf(this.conductor1X.getText())}, {Double.valueOf(this.conductor1Y.getText())}};
            relSubconductorPositions = new double[][]{xyrDataOfSubconductors[0], xyrDataOfSubconductors[1]};
            subconductorRadii = new double[][]{xyrDataOfSubconductors[2]};
            this.hvl.addOrSetAcSinglePhaseSystem(Double.valueOf(this.voltageAcSinglePhaseSystem.getText()), new Matrix((double[][])conductorPosition), new Matrix((double[][])relSubconductorPositions), new Matrix((double[][])subconductorRadii), subconductorNormalModeEnabled, subconductorNormalModeParameters, this.systemIndex);
        }
        if (this.dcTwoPhaseSystem.isSelected()) {
            if (this.voltage1DcTwoPhaseSystem.getText().equals("") || this.voltage2DcTwoPhaseSystem.getText().equals("") || this.conductor1X.getText().equals("") || this.conductor2X.getText().equals("") || this.conductor1Y.getText().equals("") || this.conductor2Y.getText().equals("")) {
                JOptionPane.showMessageDialog(this, "Some parameters were not specified!", "Missing parameters", 1);
                return;
            }
            conductorPositions = new double[][]{{Double.valueOf(this.conductor1X.getText()), Double.valueOf(this.conductor2X.getText())}, {Double.valueOf(this.conductor1Y.getText()), Double.valueOf(this.conductor2Y.getText())}};
            relSubconductorPositions = new double[][]{xyrDataOfSubconductors[0], xyrDataOfSubconductors[1]};
            subconductorRadii = new double[][]{xyrDataOfSubconductors[2]};
            double[] dcSystemVoltage = new double[]{Double.valueOf(this.voltage1DcTwoPhaseSystem.getText()), Double.valueOf(this.voltage2DcTwoPhaseSystem.getText())};
            this.hvl.addOrSetDcTwoPhaseSystem(dcSystemVoltage, new Matrix((double[][])conductorPositions), new Matrix((double[][])relSubconductorPositions), new Matrix((double[][])subconductorRadii), subconductorNormalModeEnabled, subconductorNormalModeParameters, this.systemIndex);
        }
        this.saveButtonClicked = true;
        this.closeLineProperties();
    }

    @Action
    public void closeLineProperties() {
        this.dispose();
    }

    private void initComponents() {
        this.systemGroup = new ButtonGroup();
        this.electricalSystem = new JPanel();
        this.acThreePhaseSystem = new JRadioButton();
        this.acSinglePhaseSystem = new JRadioButton();
        this.dcTwoPhaseSystem = new JRadioButton();
        this.jLabel1 = new JLabel();
        this.voltageACThreePhaseSystem = new JTextField();
        this.jLabel2 = new JLabel();
        this.jLabel4 = new JLabel();
        this.voltageAcSinglePhaseSystem = new JTextField();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.voltage1DcTwoPhaseSystem = new JTextField();
        this.jLabel38 = new JLabel();
        this.jLabel39 = new JLabel();
        this.voltage2DcTwoPhaseSystem = new JTextField();
        this.jLabel40 = new JLabel();
        this.jLabel41 = new JLabel();
        this.frequencyACThreePhaseSystem = new JTextField();
        this.frequencyACSinglePhaseSystem = new JTextField();
        this.jLabel3 = new JLabel();
        this.jLabel8 = new JLabel();
        this.conductors = new JPanel();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.conductor1X = new JTextField();
        this.jLabel11 = new JLabel();
        this.conductor1Y = new JTextField();
        this.jLabel12 = new JLabel();
        this.jLabel13 = new JLabel();
        this.jLabel14 = new JLabel();
        this.jLabel15 = new JLabel();
        this.conductor2X = new JTextField();
        this.jLabel16 = new JLabel();
        this.jLabel17 = new JLabel();
        this.conductor2Y = new JTextField();
        this.jLabel18 = new JLabel();
        this.jLabel19 = new JLabel();
        this.jLabel20 = new JLabel();
        this.conductor3X = new JTextField();
        this.jLabel21 = new JLabel();
        this.jLabel22 = new JLabel();
        this.conductor3Y = new JTextField();
        this.jLabel23 = new JLabel();
        this.subconductors = new JPanel();
        this.subconductorMode = new JTabbedPane();
        this.subconductorNormalMode = new JPanel();
        this.jLabel24 = new JLabel();
        this.numberOfSubconductors = new JSpinner();
        this.jLabel25 = new JLabel();
        this.subconductorDiameterNormal = new JTextField();
        this.jLabel26 = new JLabel();
        this.jLabel27 = new JLabel();
        this.bundleDiameter = new JTextField();
        this.jLabel28 = new JLabel();
        this.jLabel29 = new JLabel();
        this.bundlePlacementStartingAngle = new JTextField();
        this.jLabel30 = new JLabel();
        this.subconductorExpertMode = new JPanel();
        this.subconductorScrollPane = new JScrollPane();
        this.subconductorListModel = new DefaultListModel();
        this.subconductorListModel.add(0, "New Subconductor");
        this.subconductorListModel.add(1, "SC1 (x=-100mm y=0mm d=30mm)");
        this.subconductorListModel.add(2, "SC2 (x=100mm y=0mm d=40mm)");
        this.subconductorList = new JList(this.subconductorListModel);
        this.jLabel31 = new JLabel();
        this.jLabel32 = new JLabel();
        this.subconductorX = new JTextField();
        this.jLabel33 = new JLabel();
        this.jLabel34 = new JLabel();
        this.subconductorY = new JTextField();
        this.jLabel35 = new JLabel();
        this.jLabel36 = new JLabel();
        this.subconductorDiameterExpert = new JTextField();
        this.jLabel37 = new JLabel();
        this.saveSubconductorButton = new JButton();
        this.removeSubconductorButton = new JButton();
        this.subconductorChart = new ChartPanel(this.chart);
        this.saveButton = new JButton();
        this.setDefaultCloseOperation(2);
        ResourceMap resourceMap = Application.getInstance(HVLNoiseApp.class).getContext().getResourceMap(HVLNoiseSystemProperties.class);
        this.setTitle(resourceMap.getString("HVLNoiseSystemProperties.title", new Object[0]));
        this.setBounds(new Rectangle(0, 0, 0, 0));
        this.setModal(true);
        this.setName("HVLNoiseSystemProperties");
        this.setResizable(false);
        this.electricalSystem.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("electricalSystem.border.title", new Object[0])));
        this.electricalSystem.setName("electricalSystem");
        this.systemGroup.add(this.acThreePhaseSystem);
        this.acThreePhaseSystem.setSelected(true);
        this.acThreePhaseSystem.setText(resourceMap.getString("acThreePhaseSystem.text", new Object[0]));
        this.acThreePhaseSystem.setActionCommand(resourceMap.getString("acThreePhaseSystem.actionCommand", new Object[0]));
        this.acThreePhaseSystem.setName("acThreePhaseSystem");
        this.acThreePhaseSystem.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                HVLNoiseSystemProperties.this.acThreePhaseSystemItemStateChanged(evt);
            }
        });
        this.systemGroup.add(this.acSinglePhaseSystem);
        this.acSinglePhaseSystem.setText(resourceMap.getString("acSinglePhaseSystem.text", new Object[0]));
        this.acSinglePhaseSystem.setEnabled(false);
        this.acSinglePhaseSystem.setName("acSinglePhaseSystem");
        this.acSinglePhaseSystem.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                HVLNoiseSystemProperties.this.acSinglePhaseSystemItemStateChanged(evt);
            }
        });
        this.systemGroup.add(this.dcTwoPhaseSystem);
        this.dcTwoPhaseSystem.setText(resourceMap.getString("dcTwoPhaseSystem.text", new Object[0]));
        this.dcTwoPhaseSystem.setEnabled(false);
        this.dcTwoPhaseSystem.setName("dcTwoPhaseSystem");
        this.dcTwoPhaseSystem.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                HVLNoiseSystemProperties.this.dcTwoPhaseSystemItemStateChanged(evt);
            }
        });
        this.jLabel1.setText(resourceMap.getString("jLabel1.text", new Object[0]));
        this.jLabel1.setName("jLabel1");
        this.voltageACThreePhaseSystem.setText(resourceMap.getString("voltageACThreePhaseSystem.text", new Object[0]));
        this.voltageACThreePhaseSystem.setInputVerifier(new DecimalNumberVerifier(DecimalNumberVerifierType.POSITIVE_DECIMAL_NUMBER_WITH_ZERO, this.verifierFlag));
        this.voltageACThreePhaseSystem.setName("voltageACThreePhaseSystem");
        this.jLabel2.setText(resourceMap.getString("jLabel2.text", new Object[0]));
        this.jLabel2.setName("jLabel2");
        this.jLabel4.setText(resourceMap.getString("jLabel4.text", new Object[0]));
        this.jLabel4.setName("jLabel4");
        this.voltageAcSinglePhaseSystem.setText(resourceMap.getString("voltageAcSinglePhaseSystem.text", new Object[0]));
        this.voltageAcSinglePhaseSystem.setEnabled(false);
        this.voltageAcSinglePhaseSystem.setInputVerifier(new DecimalNumberVerifier(DecimalNumberVerifierType.POSITIVE_DECIMAL_NUMBER_WITH_ZERO, this.verifierFlag));
        this.voltageAcSinglePhaseSystem.setName("voltageAcSinglePhaseSystem");
        this.jLabel5.setText(resourceMap.getString("jLabel5.text", new Object[0]));
        this.jLabel5.setName("jLabel5");
        this.jLabel6.setText(resourceMap.getString("jLabel6.text", new Object[0]));
        this.jLabel6.setName("jLabel6");
        this.jLabel7.setText(resourceMap.getString("jLabel7.text", new Object[0]));
        this.jLabel7.setName("jLabel7");
        this.voltage1DcTwoPhaseSystem.setEnabled(false);
        this.voltage1DcTwoPhaseSystem.setInputVerifier(new DecimalNumberVerifier(DecimalNumberVerifierType.DECIMAL_NUMBER, this.verifierFlag));
        this.voltage1DcTwoPhaseSystem.setName("voltage1DcTwoPhaseSystem");
        this.jLabel38.setText(resourceMap.getString("jLabel38.text", new Object[0]));
        this.jLabel38.setName("jLabel38");
        this.jLabel39.setText(resourceMap.getString("jLabel39.text", new Object[0]));
        this.jLabel39.setName("jLabel39");
        this.voltage2DcTwoPhaseSystem.setEnabled(false);
        this.voltage2DcTwoPhaseSystem.setInputVerifier(new DecimalNumberVerifier(DecimalNumberVerifierType.DECIMAL_NUMBER, this.verifierFlag));
        this.voltage2DcTwoPhaseSystem.setName("voltage2DcTwoPhaseSystem");
        this.jLabel40.setText(resourceMap.getString("jLabel40.text", new Object[0]));
        this.jLabel40.setName("jLabel40");
        this.jLabel41.setText(resourceMap.getString("jLabel41.text", new Object[0]));
        this.jLabel41.setName("jLabel41");
        this.frequencyACThreePhaseSystem.setText(resourceMap.getString("frequencyACThreePhaseSystem.text", new Object[0]));
        this.frequencyACThreePhaseSystem.setEnabled(false);
        this.frequencyACThreePhaseSystem.setName("frequencyACThreePhaseSystem");
        this.frequencyACSinglePhaseSystem.setText(resourceMap.getString("frequencyACSinglePhaseSystem.text", new Object[0]));
        this.frequencyACSinglePhaseSystem.setEnabled(false);
        this.frequencyACSinglePhaseSystem.setName("frequencyACSinglePhaseSystem");
        this.jLabel3.setText(resourceMap.getString("jLabel3.text", new Object[0]));
        this.jLabel3.setName("jLabel3");
        this.jLabel8.setText(resourceMap.getString("jLabel8.text", new Object[0]));
        this.jLabel8.setName("jLabel8");
        GroupLayout electricalSystemLayout = new GroupLayout(this.electricalSystem);
        this.electricalSystem.setLayout(electricalSystemLayout);
        electricalSystemLayout.setHorizontalGroup(electricalSystemLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(electricalSystemLayout.createSequentialGroup().addContainerGap().addGroup(electricalSystemLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(electricalSystemLayout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.voltageACThreePhaseSystem, -2, 40, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2)).addGroup(electricalSystemLayout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.voltageAcSinglePhaseSystem, -2, 40, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel5)).addComponent(this.acSinglePhaseSystem).addComponent(this.acThreePhaseSystem).addComponent(this.dcTwoPhaseSystem).addGroup(electricalSystemLayout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.voltage1DcTwoPhaseSystem, -2, 40, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel38).addGap(34, 34, 34).addGroup(electricalSystemLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(electricalSystemLayout.createSequentialGroup().addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.frequencyACThreePhaseSystem, -2, 40, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3)).addGroup(electricalSystemLayout.createSequentialGroup().addComponent(this.jLabel39).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.voltage2DcTwoPhaseSystem, -2, 40, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel40)).addGroup(electricalSystemLayout.createSequentialGroup().addComponent(this.jLabel41).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.frequencyACSinglePhaseSystem, -2, 40, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel8))))).addContainerGap(194, Short.MAX_VALUE)));
        electricalSystemLayout.setVerticalGroup(electricalSystemLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(electricalSystemLayout.createSequentialGroup().addComponent(this.acThreePhaseSystem).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(electricalSystemLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.voltageACThreePhaseSystem, -2, -1, -2).addComponent(this.jLabel2).addComponent(this.jLabel7).addComponent(this.frequencyACThreePhaseSystem, -2, -1, -2).addComponent(this.jLabel3)).addGap(11, 11, 11).addComponent(this.acSinglePhaseSystem).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(electricalSystemLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.voltageAcSinglePhaseSystem, -2, -1, -2).addComponent(this.jLabel4).addComponent(this.jLabel5).addComponent(this.jLabel41).addComponent(this.frequencyACSinglePhaseSystem, -2, -1, -2).addComponent(this.jLabel8)).addGap(12, 12, 12).addComponent(this.dcTwoPhaseSystem).addGap(2, 2, 2).addGroup(electricalSystemLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.voltage1DcTwoPhaseSystem, -2, -1, -2).addComponent(this.jLabel38).addComponent(this.jLabel39).addComponent(this.voltage2DcTwoPhaseSystem, -2, -1, -2).addComponent(this.jLabel40)).addContainerGap()));
        this.conductors.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("conductors.border.title", new Object[0])));
        this.conductors.setName("conductors");
        this.jLabel9.setText(resourceMap.getString("jLabel9.text", new Object[0]));
        this.jLabel9.setName("jLabel9");
        this.jLabel10.setText(resourceMap.getString("jLabel10.text", new Object[0]));
        this.jLabel10.setName("jLabel10");
        this.conductor1X.setText(resourceMap.getString("conductor1X.text", new Object[0]));
        this.conductor1X.setInputVerifier(new DecimalNumberVerifier(DecimalNumberVerifierType.DECIMAL_NUMBER, this.verifierFlag));
        this.conductor1X.setName("conductor1X");
        this.jLabel11.setText(resourceMap.getString("jLabel11.text", new Object[0]));
        this.jLabel11.setName("jLabel11");
        this.conductor1Y.setText(resourceMap.getString("conductor1Y.text", new Object[0]));
        this.conductor1Y.setInputVerifier(new DecimalNumberVerifier(DecimalNumberVerifierType.POSITIVE_DECIMAL_NUMBER_WITHOUT_ZERO, this.verifierFlag));
        this.conductor1Y.setName("conductor1Y");
        this.jLabel12.setText(resourceMap.getString("jLabel12.text", new Object[0]));
        this.jLabel12.setName("jLabel12");
        this.jLabel13.setText(resourceMap.getString("jLabel13.text", new Object[0]));
        this.jLabel13.setName("jLabel13");
        this.jLabel14.setText(resourceMap.getString("jLabel14.text", new Object[0]));
        this.jLabel14.setName("jLabel14");
        this.jLabel15.setText(resourceMap.getString("jLabel15.text", new Object[0]));
        this.jLabel15.setName("jLabel15");
        this.conductor2X.setText(resourceMap.getString("conductor2X.text", new Object[0]));
        this.conductor2X.setInputVerifier(new DecimalNumberVerifier(DecimalNumberVerifierType.DECIMAL_NUMBER, this.verifierFlag));
        this.conductor2X.setName("conductor2X");
        this.jLabel16.setText(resourceMap.getString("jLabel16.text", new Object[0]));
        this.jLabel16.setName("jLabel16");
        this.jLabel17.setText(resourceMap.getString("jLabel17.text", new Object[0]));
        this.jLabel17.setName("jLabel17");
        this.conductor2Y.setText(resourceMap.getString("conductor2Y.text", new Object[0]));
        this.conductor2Y.setInputVerifier(new DecimalNumberVerifier(DecimalNumberVerifierType.POSITIVE_DECIMAL_NUMBER_WITHOUT_ZERO, this.verifierFlag));
        this.conductor2Y.setName("conductor2Y");
        this.jLabel18.setText(resourceMap.getString("jLabel18.text", new Object[0]));
        this.jLabel18.setName("jLabel18");
        this.jLabel19.setText(resourceMap.getString("jLabel19.text", new Object[0]));
        this.jLabel19.setName("jLabel19");
        this.jLabel20.setText(resourceMap.getString("jLabel20.text", new Object[0]));
        this.jLabel20.setName("jLabel20");
        this.conductor3X.setText(resourceMap.getString("conductor3X.text", new Object[0]));
        this.conductor3X.setInputVerifier(new DecimalNumberVerifier(DecimalNumberVerifierType.DECIMAL_NUMBER, this.verifierFlag));
        this.conductor3X.setName("conductor3X");
        this.jLabel21.setText(resourceMap.getString("jLabel21.text", new Object[0]));
        this.jLabel21.setName("jLabel21");
        this.jLabel22.setText(resourceMap.getString("jLabel22.text", new Object[0]));
        this.jLabel22.setName("jLabel22");
        this.conductor3Y.setText(resourceMap.getString("conductor3Y.text", new Object[0]));
        this.conductor3Y.setInputVerifier(new DecimalNumberVerifier(DecimalNumberVerifierType.POSITIVE_DECIMAL_NUMBER_WITHOUT_ZERO, this.verifierFlag));
        this.conductor3Y.setName("conductor3Y");
        this.jLabel23.setText(resourceMap.getString("jLabel23.text", new Object[0]));
        this.jLabel23.setName("jLabel23");
        GroupLayout conductorsLayout = new GroupLayout(this.conductors);
        this.conductors.setLayout(conductorsLayout);
        conductorsLayout.setHorizontalGroup(conductorsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(conductorsLayout.createSequentialGroup().addContainerGap().addGroup(conductorsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel9).addGroup(conductorsLayout.createSequentialGroup().addComponent(this.jLabel10).addGap(4, 4, 4).addComponent(this.conductor1X, -2, 40, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel12)).addGroup(conductorsLayout.createSequentialGroup().addComponent(this.jLabel11).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.conductor1Y, -2, 40, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel13))).addGap(38, 38, 38).addGroup(conductorsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel14).addGroup(conductorsLayout.createSequentialGroup().addComponent(this.jLabel15).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.conductor2X, -2, 40, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel16)).addGroup(conductorsLayout.createSequentialGroup().addComponent(this.jLabel17).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.conductor2Y, -2, 40, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel18))).addGap(40, 40, 40).addGroup(conductorsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(conductorsLayout.createSequentialGroup().addComponent(this.jLabel22).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.conductor3Y, -2, 40, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel23)).addGroup(conductorsLayout.createSequentialGroup().addComponent(this.jLabel20).addGap(4, 4, 4).addComponent(this.conductor3X, -2, 40, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel21)).addComponent(this.jLabel19)).addContainerGap(192, Short.MAX_VALUE)));
        conductorsLayout.setVerticalGroup(conductorsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(conductorsLayout.createSequentialGroup().addGroup(conductorsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel9).addComponent(this.jLabel14).addComponent(this.jLabel19)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(conductorsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel10).addComponent(this.conductor1X, -2, -1, -2).addComponent(this.jLabel12).addComponent(this.jLabel15).addComponent(this.jLabel16).addComponent(this.conductor2X, -2, -1, -2).addComponent(this.jLabel20).addComponent(this.conductor3X, -2, -1, -2).addComponent(this.jLabel21)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(conductorsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel11).addComponent(this.conductor1Y, -2, -1, -2).addComponent(this.jLabel13).addComponent(this.jLabel17).addComponent(this.conductor2Y, -2, -1, -2).addComponent(this.jLabel18).addComponent(this.jLabel22).addComponent(this.conductor3Y, -2, -1, -2).addComponent(this.jLabel23)).addContainerGap(-1, Short.MAX_VALUE)));
        this.subconductors.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("subconductors.border.title", new Object[0])));
        this.subconductors.setName("subconductors");
        this.subconductorMode.setName("subconductorMode");
        this.subconductorMode.setPreferredSize(new Dimension(226, 218));
        this.subconductorMode.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                HVLNoiseSystemProperties.this.subconductorModeStateChanged(evt);
            }
        });
        this.subconductorNormalMode.setName("subconductorNormalMode");
        this.jLabel24.setText(resourceMap.getString("jLabel24.text", new Object[0]));
        this.jLabel24.setName("jLabel24");
        this.numberOfSubconductors.setModel(new SpinnerNumberModel((Number)4, Integer.valueOf(2), null, (Number)1));
        this.numberOfSubconductors.setName("numberOfSubconductors");
        this.numberOfSubconductors.setValue(new Integer(4));
        this.numberOfSubconductors.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                HVLNoiseSystemProperties.this.numberOfSubconductorsStateChanged(evt);
            }
        });
        this.jLabel25.setText(resourceMap.getString("jLabel25.text", new Object[0]));
        this.jLabel25.setName("jLabel25");
        this.subconductorDiameterNormal.setText(resourceMap.getString("subconductorDiameterNormal.text", new Object[0]));
        this.subconductorDiameterNormal.setInputVerifier(new DecimalNumberVerifier(DecimalNumberVerifierType.DECIMAL_NUMBER_WITHIN_RANGE, this.verifierFlag, 20.0, 80.0));
        this.subconductorDiameterNormal.setName("subconductorDiameterNormal");
        this.subconductorDiameterNormal.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                HVLNoiseSystemProperties.this.subconductorDiameterNormalFocusLost(evt);
            }
        });
        this.jLabel26.setText(resourceMap.getString("jLabel26.text", new Object[0]));
        this.jLabel26.setName("jLabel26");
        this.jLabel27.setText(resourceMap.getString("jLabel27.text", new Object[0]));
        this.jLabel27.setName("jLabel27");
        this.bundleDiameter.setText(resourceMap.getString("bundleDiameter.text", new Object[0]));
        this.bundleDiameter.setInputVerifier(new DecimalNumberVerifier(DecimalNumberVerifierType.POSITIVE_DECIMAL_NUMBER_WITHOUT_ZERO, this.verifierFlag));
        this.bundleDiameter.setName("bundleDiameter");
        this.bundleDiameter.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                HVLNoiseSystemProperties.this.bundleDiameterFocusLost(evt);
            }
        });
        this.jLabel28.setText(resourceMap.getString("jLabel28.text", new Object[0]));
        this.jLabel28.setName("jLabel28");
        this.jLabel29.setText(resourceMap.getString("jLabel29.text", new Object[0]));
        this.jLabel29.setName("jLabel29");
        this.bundlePlacementStartingAngle.setText(resourceMap.getString("bundlePlacementStartingAngle.text", new Object[0]));
        this.bundlePlacementStartingAngle.setInputVerifier(new DecimalNumberVerifier(DecimalNumberVerifierType.DECIMAL_NUMBER_WITHIN_RANGE, this.verifierFlag, 0.0, 360.0));
        this.bundlePlacementStartingAngle.setName("bundlePlacementStartingAngle");
        this.bundlePlacementStartingAngle.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                HVLNoiseSystemProperties.this.bundlePlacementStartingAngleFocusLost(evt);
            }
        });
        this.jLabel30.setText(resourceMap.getString("jLabel30.text", new Object[0]));
        this.jLabel30.setName("jLabel30");
        GroupLayout subconductorNormalModeLayout = new GroupLayout(this.subconductorNormalMode);
        this.subconductorNormalMode.setLayout(subconductorNormalModeLayout);
        subconductorNormalModeLayout.setHorizontalGroup(subconductorNormalModeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(subconductorNormalModeLayout.createSequentialGroup().addContainerGap().addGroup(subconductorNormalModeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(subconductorNormalModeLayout.createSequentialGroup().addComponent(this.jLabel24).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.numberOfSubconductors, -2, 40, -2)).addGroup(subconductorNormalModeLayout.createSequentialGroup().addComponent(this.jLabel25).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.subconductorDiameterNormal, -2, 40, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel26)).addGroup(subconductorNormalModeLayout.createSequentialGroup().addComponent(this.jLabel27).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bundleDiameter, -2, 40, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel28)).addGroup(subconductorNormalModeLayout.createSequentialGroup().addComponent(this.jLabel29).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bundlePlacementStartingAngle, -2, 40, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel30))).addContainerGap(31, Short.MAX_VALUE)));
        subconductorNormalModeLayout.setVerticalGroup(subconductorNormalModeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(subconductorNormalModeLayout.createSequentialGroup().addContainerGap().addGroup(subconductorNormalModeLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel24).addComponent(this.numberOfSubconductors, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(subconductorNormalModeLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel25).addComponent(this.subconductorDiameterNormal, -2, -1, -2).addComponent(this.jLabel26)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(subconductorNormalModeLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel27).addComponent(this.bundleDiameter, -2, -1, -2).addComponent(this.jLabel28)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(subconductorNormalModeLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel29).addComponent(this.bundlePlacementStartingAngle, -2, -1, -2).addComponent(this.jLabel30)).addContainerGap(76, Short.MAX_VALUE)));
        this.subconductorMode.addTab(resourceMap.getString("subconductorNormalMode.TabConstraints.tabTitle", new Object[0]), this.subconductorNormalMode);
        this.subconductorExpertMode.setName("subconductorExpertMode");
        this.subconductorScrollPane.setName("subconductorScrollPane");
        this.subconductorList.setSelectionMode(0);
        this.subconductorList.setMaximumSize(null);
        this.subconductorList.setMinimumSize(null);
        this.subconductorList.setName("subconductorList");
        this.subconductorList.setPreferredSize(null);
        this.subconductorList.setSelectedIndex(0);
        this.subconductorList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                HVLNoiseSystemProperties.this.subconductorListValueChanged(evt);
            }
        });
        this.subconductorScrollPane.setViewportView(this.subconductorList);
        this.jLabel31.setText(resourceMap.getString("jLabel31.text", new Object[0]));
        this.jLabel31.setName("jLabel31");
        this.jLabel32.setText(resourceMap.getString("jLabel32.text", new Object[0]));
        this.jLabel32.setName("jLabel32");
        this.subconductorX.setText(resourceMap.getString("subconductorX.text", new Object[0]));
        this.subconductorX.setInputVerifier(new DecimalNumberVerifier(DecimalNumberVerifierType.DECIMAL_NUMBER, this.verifierFlagExpertMode));
        this.subconductorX.setName("subconductorX");
        this.jLabel33.setText(resourceMap.getString("jLabel33.text", new Object[0]));
        this.jLabel33.setName("jLabel33");
        this.jLabel34.setText(resourceMap.getString("jLabel34.text", new Object[0]));
        this.jLabel34.setName("jLabel34");
        this.subconductorY.setText(resourceMap.getString("subconductorY.text", new Object[0]));
        this.subconductorY.setInputVerifier(new DecimalNumberVerifier(DecimalNumberVerifierType.DECIMAL_NUMBER, this.verifierFlagExpertMode));
        this.subconductorY.setName("subconductorY");
        this.jLabel35.setText(resourceMap.getString("jLabel35.text", new Object[0]));
        this.jLabel35.setName("jLabel35");
        this.jLabel36.setText(resourceMap.getString("jLabel36.text", new Object[0]));
        this.jLabel36.setName("jLabel36");
        this.subconductorDiameterExpert.setText(resourceMap.getString("subconductorDiameterExpert.text", new Object[0]));
        this.subconductorDiameterExpert.setInputVerifier(new DecimalNumberVerifier(DecimalNumberVerifierType.DECIMAL_NUMBER_WITHIN_RANGE, this.verifierFlagExpertMode, 20.0, 80.0));
        this.subconductorDiameterExpert.setName("subconductorDiameterExpert");
        this.jLabel37.setText(resourceMap.getString("jLabel37.text", new Object[0]));
        this.jLabel37.setName("jLabel37");
        ApplicationActionMap actionMap = Application.getInstance(HVLNoiseApp.class).getContext().getActionMap(HVLNoiseSystemProperties.class, this);
        this.saveSubconductorButton.setAction(actionMap.get("saveSubconductorInExpertMode"));
        this.saveSubconductorButton.setText(resourceMap.getString("saveSubconductorButton.text", new Object[0]));
        this.saveSubconductorButton.setName("saveSubconductorButton");
        this.removeSubconductorButton.setAction(actionMap.get("removeSubconductorInExpertMode"));
        this.removeSubconductorButton.setText(resourceMap.getString("removeSubconductorButton.text", new Object[0]));
        this.removeSubconductorButton.setName("removeSubconductorButton");
        GroupLayout subconductorExpertModeLayout = new GroupLayout(this.subconductorExpertMode);
        this.subconductorExpertMode.setLayout(subconductorExpertModeLayout);
        subconductorExpertModeLayout.setHorizontalGroup(subconductorExpertModeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(subconductorExpertModeLayout.createSequentialGroup().addContainerGap().addGroup(subconductorExpertModeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.subconductorScrollPane, -2, 200, -2).addComponent(this.jLabel31).addGroup(subconductorExpertModeLayout.createSequentialGroup().addComponent(this.jLabel32).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.subconductorX, -2, 40, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel33).addGap(42, 42, 42).addComponent(this.jLabel34).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.subconductorY, -2, 40, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel35)).addGroup(subconductorExpertModeLayout.createSequentialGroup().addGroup(subconductorExpertModeLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.saveSubconductorButton).addGroup(subconductorExpertModeLayout.createSequentialGroup().addComponent(this.jLabel36).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.subconductorDiameterExpert, -2, 40, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(subconductorExpertModeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel37).addComponent(this.removeSubconductorButton)))).addContainerGap(11, Short.MAX_VALUE)));
        subconductorExpertModeLayout.setVerticalGroup(subconductorExpertModeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(subconductorExpertModeLayout.createSequentialGroup().addContainerGap().addComponent(this.subconductorScrollPane, -1, 49, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel31).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(subconductorExpertModeLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel32).addComponent(this.subconductorX, -2, -1, -2).addComponent(this.jLabel33).addComponent(this.jLabel34).addComponent(this.subconductorY, -2, -1, -2).addComponent(this.jLabel35)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(subconductorExpertModeLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel36).addComponent(this.subconductorDiameterExpert, -2, -1, -2).addComponent(this.jLabel37)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(subconductorExpertModeLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.saveSubconductorButton).addComponent(this.removeSubconductorButton)).addContainerGap(14, Short.MAX_VALUE)));
        this.subconductorMode.addTab(resourceMap.getString("subconductorExpertMode.TabConstraints.tabTitle", new Object[0]), this.subconductorExpertMode);
        this.subconductorChart.setName("subconductorChart");
        this.subconductorChart.setPreferredSize(new Dimension(215, 215));
        GroupLayout subconductorChartLayout = new GroupLayout(this.subconductorChart);
        this.subconductorChart.setLayout(subconductorChartLayout);
        subconductorChartLayout.setHorizontalGroup(subconductorChartLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 215, Short.MAX_VALUE));
        subconductorChartLayout.setVerticalGroup(subconductorChartLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 215, Short.MAX_VALUE));
        GroupLayout subconductorsLayout = new GroupLayout(this.subconductors);
        this.subconductors.setLayout(subconductorsLayout);
        subconductorsLayout.setHorizontalGroup(subconductorsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(subconductorsLayout.createSequentialGroup().addContainerGap().addComponent(this.subconductorMode, -2, 226, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 17, Short.MAX_VALUE).addComponent(this.subconductorChart, -2, -1, -2).addContainerGap()));
        subconductorsLayout.setVerticalGroup(subconductorsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(subconductorsLayout.createSequentialGroup().addGroup(subconductorsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.subconductorMode, -2, -1, -2).addComponent(this.subconductorChart, -2, -1, -2)).addContainerGap()));
        this.subconductorMode.getAccessibleContext().setAccessibleName(resourceMap.getString("jTabbedPane1.AccessibleContext.accessibleName", new Object[0]));
        this.saveButton.setAction(actionMap.get("saveLineProperties"));
        this.saveButton.setText(resourceMap.getString("saveButton.text", new Object[0]));
        this.saveButton.setName("saveButton");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.electricalSystem, -2, -1, -2)).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.conductors, -2, -1, -2)).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.subconductors, -2, -1, -2)).addGroup(layout.createSequentialGroup().addGap(230, 230, 230).addComponent(this.saveButton))).addContainerGap(10, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.electricalSystem, -2, 190, -2).addGap(10, 10, 10).addComponent(this.conductors, -2, 100, -2).addGap(10, 10, 10).addComponent(this.subconductors, -2, 250, -2).addGap(10, 10, 10).addComponent(this.saveButton).addContainerGap(11, Short.MAX_VALUE)));
        this.pack();
    }

    private void subconductorDiameterNormalFocusLost(FocusEvent evt) {
        if (this.subconductorMode.getSelectedIndex() == 0) {
            this.setSubconductorDataInNormalMode();
        }
    }

    private void bundleDiameterFocusLost(FocusEvent evt) {
        if (this.subconductorMode.getSelectedIndex() == 0) {
            this.setSubconductorDataInNormalMode();
        }
    }

    private void bundlePlacementStartingAngleFocusLost(FocusEvent evt) {
        if (this.subconductorMode.getSelectedIndex() == 0) {
            this.setSubconductorDataInNormalMode();
        }
    }

    private void numberOfSubconductorsStateChanged(ChangeEvent evt) {
        this.setSubconductorDataInNormalMode();
    }

    private void acThreePhaseSystemItemStateChanged(ItemEvent evt) {
        this.onElectricalSystemChange();
    }

    private void acSinglePhaseSystemItemStateChanged(ItemEvent evt) {
        this.onElectricalSystemChange();
    }

    private void dcTwoPhaseSystemItemStateChanged(ItemEvent evt) {
        this.onElectricalSystemChange();
    }

    private void subconductorModeStateChanged(ChangeEvent evt) {
        this.onSubconductorModeChange();
    }

    private void subconductorListValueChanged(ListSelectionEvent evt) {
        if (!evt.getValueIsAdjusting()) {
            if (this.subconductorList.getSelectedIndex() <= 0) {
                this.subconductorX.setText("");
                this.subconductorY.setText("");
                this.subconductorDiameterExpert.setText("");
            } else {
                String listStr = (String)this.subconductorList.getModel().getElementAt(this.subconductorList.getSelectedIndex());
                Pattern pattern = Pattern.compile("=-?[0-9.]+mm");
                Matcher matcher = pattern.matcher(listStr);
                matcher.find();
                this.subconductorX.setText(listStr.substring(matcher.start() + 1, matcher.end() - 2));
                matcher.find();
                this.subconductorY.setText(listStr.substring(matcher.start() + 1, matcher.end() - 2));
                matcher.find();
                this.subconductorDiameterExpert.setText(listStr.substring(matcher.start() + 1, matcher.end() - 2));
            }
        }
    }
}

