/*
 * Decompiled with CFR 0.152.
 */
package hvlnoise;

import Jama.Matrix;
import hvlnoise.AudibleNoise;
import hvlnoise.ElectricalSystem;
import hvlnoise.SystemType;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.io.Serializable;
import java.util.ArrayList;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.annotations.XYTextAnnotation;
import org.jfree.chart.renderer.xy.XYBubbleRenderer;
import org.jfree.chart.renderer.xy.XYDotRenderer;
import org.jfree.data.xy.DefaultXYDataset;
import org.jfree.data.xy.DefaultXYZDataset;
import org.jfree.ui.TextAnchor;

public class HighVoltageLine
implements Serializable {
    private ArrayList<ElectricalSystem> systems = new ArrayList();
    private int numberOfAcThreePhaseSystems = 0;
    private int numberOfAcSinglePhaseSystems = 0;
    private int numberOfDcTwoPhaseSystems = 0;
    private DefaultXYZDataset xyzDataset = new DefaultXYZDataset();
    private DefaultXYDataset xyDataset = new DefaultXYDataset();
    private XYBubbleRenderer bubbleRenderer = new XYBubbleRenderer(1);
    private XYDotRenderer dotRenderer = new XYDotRenderer();
    private ArrayList<XYTextAnnotation> conductorAnnotations;
    private ArrayList<XYTextAnnotation> splAnnotations;

    public HighVoltageLine() {
        this.dotRenderer.setDotWidth(5);
        this.dotRenderer.setDotHeight(5);
        this.conductorAnnotations = new ArrayList();
        this.splAnnotations = new ArrayList();
    }

    public void addOrSetAcThreePhaseSystem(double acSystemVoltage, Matrix conductorPositions, Matrix relSubconductorPositions, Matrix subconductorRadii, boolean subconductorNormalModeEnabled, double[] subconductorNormalModeParameters, int systemIndex) {
        ElectricalSystem system = new ElectricalSystem();
        system.createAcThreePhaseSystem(acSystemVoltage, conductorPositions, relSubconductorPositions, subconductorRadii, subconductorNormalModeEnabled, subconductorNormalModeParameters);
        if (systemIndex == -1) {
            this.systems.add(system);
            ++this.numberOfAcThreePhaseSystems;
        } else {
            this.systems.set(systemIndex, system);
        }
        this.drawSystem(system);
    }

    public void addOrSetAcSinglePhaseSystem(double acSystemVoltage, Matrix conductorPosition, Matrix relSubconductorPositions, Matrix subconductorRadii, boolean subconductorNormalModeEnabled, double[] subconductorNormalModeParameters, int systemIndex) {
        ElectricalSystem system = new ElectricalSystem();
        system.createAcSinglePhaseSystem(acSystemVoltage, conductorPosition, relSubconductorPositions, subconductorRadii, subconductorNormalModeEnabled, subconductorNormalModeParameters);
        if (systemIndex == -1) {
            this.systems.add(system);
            ++this.numberOfAcSinglePhaseSystems;
        } else {
            this.systems.set(systemIndex, system);
        }
        this.drawSystem(system);
    }

    public void addOrSetDcTwoPhaseSystem(double[] dcSystemVoltage, Matrix conductorPositions, Matrix relSubconductorPositions, Matrix subconductorRadii, boolean subconductorNormalModeEnabled, double[] subconductorNormalModeParameters, int systemIndex) {
        ElectricalSystem system = new ElectricalSystem();
        system.createDcTwoPhaseSystem(dcSystemVoltage, conductorPositions, relSubconductorPositions, subconductorRadii, subconductorNormalModeEnabled, subconductorNormalModeParameters);
        if (systemIndex == -1) {
            this.systems.add(system);
            ++this.numberOfDcTwoPhaseSystems;
        } else {
            this.systems.set(systemIndex, system);
        }
        this.drawSystem(system);
    }

    public boolean removeSystem(int systemIndex) {
        ElectricalSystem system = this.systems.get(systemIndex);
        if (this.systems.remove(systemIndex) != null) {
            switch (system.getSystemType()) {
                case AC_THREE_PHASE_SYSTEM: {
                    --this.numberOfAcThreePhaseSystems;
                    break;
                }
                case AC_SINGLE_PHASE_SYSTEM: {
                    --this.numberOfAcSinglePhaseSystems;
                    break;
                }
                case DC_TWO_PHASE_SYSTEM: {
                    --this.numberOfDcTwoPhaseSystems;
                }
            }
            this.redrawSystems();
            return true;
        }
        return false;
    }

    public ElectricalSystem getSystem(int index) {
        return this.systems.get(index);
    }

    public int getSystemIndex(ElectricalSystem system) {
        return this.systems.indexOf(system);
    }

    public ElectricalSystem[] getAcThreePhaseSystems() {
        ElectricalSystem[] acThreePhaseSystems = new ElectricalSystem[this.numberOfAcThreePhaseSystems];
        int z = 0;
        for (int i = 0; i < this.systems.size(); ++i) {
            ElectricalSystem system = this.systems.get(i);
            if (system.getSystemType() != SystemType.AC_THREE_PHASE_SYSTEM) continue;
            acThreePhaseSystems[z] = system;
            ++z;
        }
        return acThreePhaseSystems;
    }

    public int[] getAcThreePhaseSystemIndices() {
        int[] acThreePhaseSystemIndices = new int[this.numberOfAcThreePhaseSystems];
        int z = 0;
        for (int i = 0; i < this.systems.size(); ++i) {
            ElectricalSystem system = this.systems.get(i);
            if (system.getSystemType() != SystemType.AC_THREE_PHASE_SYSTEM) continue;
            acThreePhaseSystemIndices[z] = i;
            ++z;
        }
        return acThreePhaseSystemIndices;
    }

    public ElectricalSystem[] getAcSinglePhaseSystems() {
        ElectricalSystem[] acSinglePhaseSystems = new ElectricalSystem[this.numberOfAcSinglePhaseSystems];
        int z = 0;
        for (int i = 0; i < this.systems.size(); ++i) {
            ElectricalSystem system = this.systems.get(i);
            if (system.getSystemType() != SystemType.AC_SINGLE_PHASE_SYSTEM) continue;
            acSinglePhaseSystems[z] = system;
            ++z;
        }
        return acSinglePhaseSystems;
    }

    public int[] getAcSinglePhaseSystemIndices() {
        int[] acSinglePhaseSystemIndices = new int[this.numberOfAcSinglePhaseSystems];
        int z = 0;
        for (int i = 0; i < this.systems.size(); ++i) {
            ElectricalSystem system = this.systems.get(i);
            if (system.getSystemType() != SystemType.AC_SINGLE_PHASE_SYSTEM) continue;
            acSinglePhaseSystemIndices[z] = i;
            ++z;
        }
        return acSinglePhaseSystemIndices;
    }

    public ElectricalSystem[] getDcTwoPhaseSystems() {
        ElectricalSystem[] dcTwoPhaseSystems = new ElectricalSystem[this.numberOfDcTwoPhaseSystems];
        int z = 0;
        for (int i = 0; i < this.systems.size(); ++i) {
            ElectricalSystem system = this.systems.get(i);
            if (system.getSystemType() != SystemType.DC_TWO_PHASE_SYSTEM) continue;
            dcTwoPhaseSystems[z] = system;
            ++z;
        }
        return dcTwoPhaseSystems;
    }

    public int[] getDcTwoPhaseSystemIndices() {
        int[] dcTwoPhaseSystemIndices = new int[this.numberOfDcTwoPhaseSystems];
        int z = 0;
        for (int i = 0; i < this.systems.size(); ++i) {
            ElectricalSystem system = this.systems.get(i);
            if (system.getSystemType() != SystemType.DC_TWO_PHASE_SYSTEM) continue;
            dcTwoPhaseSystemIndices[z] = i;
            ++z;
        }
        return dcTwoPhaseSystemIndices;
    }

    public int getNumberOfSystems() {
        return this.systems.size();
    }

    public DefaultXYZDataset getDefaultXYZDataset() {
        return this.xyzDataset;
    }

    public DefaultXYDataset getXYDefaultDataset() {
        return this.xyDataset;
    }

    public XYBubbleRenderer getXYBubbleRenderer() {
        return this.bubbleRenderer;
    }

    public XYDotRenderer getXYDotRenderer() {
        return this.dotRenderer;
    }

    public void calculateAndDrawSoundPowerLevelAnnotations(AudibleNoise audibleNoise) {
        for (int i = 0; i < this.systems.size(); ++i) {
            ElectricalSystem system = this.systems.get(i);
            int numberOfConductors = system.getNumberOfConductors();
            for (int j = 0; j < numberOfConductors; ++j) {
                double Lw = audibleNoise.getSoundPowerLevelLeqDuringRainOfConductor(i, j);
                Lw = (double)Math.round(Lw * 100.0) / 100.0;
                XYTextAnnotation annotation = new XYTextAnnotation("Lw=" + Lw + "dB(A)", system.getConductorAbsolutePositionX(j), system.getConductorAbsolutePositionY(j));
                annotation.setFont(new Font("SansSerif", 1, 12));
                annotation.setTextAnchor(TextAnchor.TOP_CENTER);
                annotation.setPaint((Paint)Color.blue);
                this.dotRenderer.addAnnotation((XYAnnotation)annotation);
                this.splAnnotations.add(annotation);
            }
        }
    }

    public void removeSoundPowerLevelAnnotations() {
        for (int i = 0; i < this.splAnnotations.size(); ++i) {
            this.dotRenderer.removeAnnotation((XYAnnotation)this.splAnnotations.get(i));
        }
        this.splAnnotations.clear();
    }

    private void redrawSystems() {
        int i;
        int numberOfSeries = this.xyzDataset.getSeriesCount();
        for (i = 0; i < numberOfSeries; ++i) {
            this.xyzDataset.removeSeries((Comparable)Integer.valueOf(i));
        }
        numberOfSeries = this.xyDataset.getSeriesCount();
        for (i = 0; i < numberOfSeries; ++i) {
            this.xyDataset.removeSeries((Comparable)Integer.valueOf(i));
        }
        this.conductorAnnotations.clear();
        this.dotRenderer.removeAnnotations();
        this.bubbleRenderer.clearSeriesPaints(true);
        this.dotRenderer.clearSeriesPaints(true);
        for (i = 0; i < this.systems.size(); ++i) {
            this.drawSystem(this.systems.get(i));
        }
    }

    private void drawSystem(ElectricalSystem system) {
        int numberOfConductors = system.getNumberOfConductors();
        int numberOfSubconductors = system.getNumberOfSubconductors();
        double[][] xyzData = new double[3][numberOfConductors * numberOfSubconductors];
        double[][] xyData = new double[2][numberOfConductors];
        for (int i = 0; i < numberOfConductors; ++i) {
            for (int j = 0; j < numberOfSubconductors; ++j) {
                xyzData[0][i * numberOfSubconductors + j] = system.getSubconductorAbsolutePositionX(i, j);
                xyzData[1][i * numberOfSubconductors + j] = system.getSubconductorAbsolutePositionY(i, j);
                xyzData[2][i * numberOfSubconductors + j] = system.getSubconductorRadius(j) / 1000.0;
            }
            xyData[0][i] = system.getConductorAbsolutePositionX(i);
            xyData[1][i] = system.getConductorAbsolutePositionY(i);
            int annotationIndex = 0;
            for (int k = 0; k < this.systems.indexOf(system); ++k) {
                annotationIndex += this.systems.get(k).getNumberOfConductors();
            }
            XYTextAnnotation annotation = new XYTextAnnotation("ES" + String.valueOf(this.systems.indexOf(system) + 1) + ", Ph" + String.valueOf(i + 1), xyData[0][i], xyData[1][i]);
            annotation.setFont(new Font("SansSerif", 0, 12));
            annotation.setTextAnchor(TextAnchor.BOTTOM_CENTER);
            if ((annotationIndex += i) >= this.conductorAnnotations.size()) {
                this.dotRenderer.addAnnotation((XYAnnotation)annotation);
                this.conductorAnnotations.add(annotation);
                continue;
            }
            this.dotRenderer.removeAnnotation((XYAnnotation)this.conductorAnnotations.get(annotationIndex));
            this.dotRenderer.addAnnotation((XYAnnotation)annotation);
            this.conductorAnnotations.set(annotationIndex, annotation);
        }
        this.xyzDataset.addSeries((Comparable)Integer.valueOf(this.systems.indexOf(system)), xyzData);
        this.xyDataset.addSeries((Comparable)Integer.valueOf(this.systems.indexOf(system)), xyData);
        this.bubbleRenderer.setBaseOutlinePaint((Paint)Color.lightGray);
        this.bubbleRenderer.setSeriesPaint(this.systems.indexOf(system), (Paint)Color.lightGray);
        this.dotRenderer.setSeriesPaint(this.systems.indexOf(system), (Paint)Color.magenta);
    }
}

