
/*
    Noise Model Binary Grid Format (NMBGF) File Output Library

    This file declares a set of functions that form a library for writing
    NMBGF files.
*/




#ifndef nmbgfiol_included

#define nmbgfiol_included




/*
    Define types for the five core NMBGF datatypes.
*/

typedef  char                          NMBGF_LITERAL [4];
typedef  const char*                   NMBGF_STRING;
typedef  long int                      NMBGF_INTEGER;
typedef  float                         NMBGF_FLOAT;
typedef  struct {float C1; float C2;}  NMBGF_COORDINATE;




/*
    Type NMBGF_HOC is a handle to an NMBGF output context.  A handle is
    obtained with a call to either function NMBGF_CreateOutputContext or
    function NMBGF_CreateOutputContextAttachedToFile.  This handle is then
    passed as the first parameter to all other NMBGF functions.
*/

struct NMBGF_OutputContext;

typedef  struct NMBGF_OutputContext*  NMBGF_HOC;




enum NMBGF_OutputMode
    {NMBGF_Options_OutputMode_Binary = 0x0,
     NMBGF_Options_OutputMode_ASCII  = 0x1};

typedef int (*NMBGF_FileCloseFunType)(void* FileHandle);
typedef int (*NMBGF_FileWriteFunType)
    (void* FileHandle, void* Data, NMBGF_INTEGER DataLength);




#ifdef __cplusplus
    extern "C" {
#endif



NMBGF_HOC NMBGF_CreateOutputContextAttachedToFile (const char* FileName);

NMBGF_HOC NMBGF_CreateOutputContextAttachedToFile2
    (const char* FileName, unsigned long Options);

NMBGF_HOC NMBGF_CreateOutputContext
    (void*                  FileHandle,
     NMBGF_FileCloseFunType FileCloseFun,
     NMBGF_FileWriteFunType FileWriteFun);

NMBGF_HOC NMBGF_CreateOutputContext2
    (void*                  FileHandle,
     NMBGF_FileCloseFunType FileCloseFun,
     NMBGF_FileWriteFunType FileWriteFun,
     unsigned long          Options);


void NMBGF_EndWritingOutputFile (NMBGF_HOC hOC);



int NMBGF_IsInASCIIMode (NMBGF_HOC hOC);


int NMBGF_WasError (NMBGF_HOC hOC);

void NMBGF_ResetErrorFlag (NMBGF_HOC hOC);



void NMBGF_PushOutputStreamBuffer (NMBGF_HOC hOC);

NMBGF_INTEGER NMBGF_GetTopOutputStreamBufferLengthInBytes
    (NMBGF_HOC hOC);

void NMBGF_SetTopClientStackCounter (NMBGF_HOC hOC, NMBGF_INTEGER X);

void NMBGF_IncrementTopClientStackCounter (NMBGF_HOC hOC);

NMBGF_INTEGER NMBGF_GetTopClientStackCounter (NMBGF_HOC hOC);

NMBGF_INTEGER NMBGF_GetTopStackElementCounter (NMBGF_HOC hOC);

void NMBGF_PutToTopOutputStreamBuffer
    (NMBGF_HOC hOC, void* DataBlock, NMBGF_INTEGER DataBlockLength);

void NMBGF_WriteIntegerToPreceedingBuffer
    (NMBGF_HOC hOC, NMBGF_INTEGER Count);

void NMBGF_PopOutputStreamBuffer (NMBGF_HOC hOC);

void NMBGF_AutoClosePreviousSection (NMBGF_HOC hOC);


void NMBGF_PutToTopOutputStreamBuffer_EndOfLine (NMBGF_HOC hOC);



void NMBGF_BeginOptionalSubsections (NMBGF_HOC hOC);

void NMBGF_EndOptionalSubsections (NMBGF_HOC hOC);



void NMBGF_PutStandardSectionProlog (NMBGF_HOC hOC, NMBGF_LITERAL SectionName);



void NMBGF_PutLiteral (NMBGF_HOC hOC, NMBGF_LITERAL X);

void NMBGF_PutString (NMBGF_HOC hOC, NMBGF_STRING X);

void NMBGF_PutInteger (NMBGF_HOC hOC, NMBGF_INTEGER X);

void NMBGF_PutFloat (NMBGF_HOC hOC, NMBGF_FLOAT X);

void NMBGF_PutCoordinate (NMBGF_HOC hOC, NMBGF_COORDINATE X);



void NMBGF_PutAREMSection
    (NMBGF_HOC     hOC,
     NMBGF_STRING  CATAGORY);

        void NMBGF_AREM_BeginPoints
            (NMBGF_HOC  hOC);

            void NMBGF_AREM_PutPoint
                (NMBGF_HOC         hOC,
                 NMBGF_COORDINATE  P);

        void NMBGF_AREM_PointsDone
            (NMBGF_HOC  hOC);

    void NMBGF_AREM_ClosedPolygonsDone
        (NMBGF_HOC  hOC);



void NMBGF_PutARESSection
    (NMBGF_HOC     hOC,
     NMBGF_STRING  CATAGORY);

        void NMBGF_ARES_PutPoint
            (NMBGF_HOC         hOC,
             NMBGF_COORDINATE  P);

    void NMBGF_ARES_PointsDone
        (NMBGF_HOC  hOC);



void NMBGF_PutATRCSection
    (NMBGF_HOC         hOC,
     NMBGF_STRING      NAME,
     NMBGF_COORDINATE  VALUE);



void NMBGF_PutATRFSection
    (NMBGF_HOC     hOC,
     NMBGF_STRING  NAME,
     NMBGF_FLOAT   VALUE);



void NMBGF_PutATRISection
    (NMBGF_HOC      hOC,
     NMBGF_STRING   NAME,
     NMBGF_INTEGER  VALUE);



void NMBGF_PutATRSSection
    (NMBGF_HOC     hOC,
     NMBGF_STRING  NAME,
     NMBGF_STRING  VALUE);



typedef enum
    {NMBGF_ATRT_String,
     NMBGF_ATRT_Integer,
     NMBGF_ATRT_Float,
     NMBGF_ATRT_Coordinate} NMBGF_ATRT_COLTYPE_ENUM;

void NMBGF_PutATRTSection
    (NMBGF_HOC     hOC,
     NMBGF_STRING  NAME);

            void NMBGF_ATRT_AddColumn
                (NMBGF_HOC                hOC,
                 NMBGF_STRING             COLNAME,
                 NMBGF_ATRT_COLTYPE_ENUM  COLTYPE);

        void NMBGF_ATRT_ColumnsDone
            (NMBGF_HOC  hOC);

            void NMBGF_ATRT_PutString
                (NMBGF_HOC     hOC,
                 NMBGF_STRING  X);

            void NMBGF_ATRT_PutInteger
                (NMBGF_HOC      hOC,
                 NMBGF_INTEGER  X);

            void NMBGF_ATRT_PutFloat
                (NMBGF_HOC    hOC,
                 NMBGF_FLOAT  X);

            void NMBGF_ATRT_PutCoordinate
                (NMBGF_HOC         hOC,
                 NMBGF_COORDINATE  X);

        void NMBGF_ATRT_RowDone
            (NMBGF_HOC  hOC);

    void NMBGF_ATRT_TableDone
        (NMBGF_HOC  hOC);



void NMBGF_PutBKMPSection
    (NMBGF_HOC     hOC,
     NMBGF_STRING  FILENAME,
     NMBGF_STRING  CATEGORY);



typedef enum
    {NMBGF_CART_Feet, NMBGF_CART_Meters} NMBGF_CART_UNIT_ENUM;

void NMBGF_PutCARTSection
    (NMBGF_HOC             hOC,
     NMBGF_FLOAT           LOR,
     NMBGF_FLOAT           LAR,
     NMBGF_FLOAT           XR,
     NMBGF_FLOAT           YR,
     NMBGF_CART_UNIT_ENUM  UNIT,
     NMBGF_FLOAT           ROT);



void NMBGF_PutDAPYSection
    (NMBGF_HOC  hOC);

        void NMBGF_DAPY_BeginPoints
            (NMBGF_HOC  hOC);

            void NMBGF_DAPY_PutPoint
                (NMBGF_HOC         hOC,
                 NMBGF_COORDINATE  P);

        void NMBGF_DAPY_PointsDone
            (NMBGF_HOC  hOC);

    void NMBGF_DAPY_ClosedPolygonsDone
        (NMBGF_HOC  hOC);



void NMBGF_PutDATESection
    (NMBGF_HOC      hOC,
     NMBGF_INTEGER  DAY,
     NMBGF_INTEGER  MONTH,
     NMBGF_INTEGER  YEAR);



void NMBGF_PutDESLSection
    (NMBGF_HOC     hOC,
     NMBGF_STRING  D);



void NMBGF_PutDESSSection
    (NMBGF_HOC     hOC,
     NMBGF_STRING  D);



void NMBGF_PutDPALSection
    (NMBGF_HOC  hOC);

        void NMBGF_DPAL_PutDataPoint
            (NMBGF_HOC         hOC,
             NMBGF_COORDINATE  P,
             NMBGF_FLOAT       V);

    void NMBGF_DPAL_DataPointsDone
        (NMBGF_HOC  hOC);



typedef enum
    {NMBGF_GRID_Feet, NMBGF_GRID_Meters} NMBGF_GRID_UNIT_ENUM;

void NMBGF_PutGRIDSection
    (NMBGF_HOC             hOC,
     NMBGF_STRING          NAME,
     NMBGF_INTEGER         NI,
     NMBGF_INTEGER         NJ,
     NMBGF_FLOAT           DI,
     NMBGF_FLOAT           DJ,
     NMBGF_GRID_UNIT_ENUM  UNIT,
     NMBGF_COORDINATE      ORIGIN,
     NMBGF_FLOAT           ROT);

    void NMBGF_GRID_PutGridPoint
        (NMBGF_HOC    hOC,
         NMBGF_FLOAT  V);



void NMBGF_PutGTSHSection
    (NMBGF_HOC    hOC,
     NMBGF_FLOAT  VMIN,
     NMBGF_FLOAT  VMAX);



void NMBGF_PutHEADSection
    (NMBGF_HOC   hOC,
     NMBGF_FLOAT H);



typedef enum
    {NMBGF_LINC_Feet, NMBGF_LINC_Meters} NMBGF_LINC_UNIT_ENUM;

void NMBGF_PutLINCSection
    (NMBGF_HOC             hOC,
     NMBGF_STRING          CATAGORY,
     NMBGF_LINC_UNIT_ENUM  UNIT,
     NMBGF_COORDINATE      P0,
     NMBGF_FLOAT           H0);

        void NMBGF_LINC_PutDSTRCommand
            (NMBGF_HOC    hOC,
             NMBGF_FLOAT  DIST);

        void NMBGF_LINC_PutDARRCommand
            (NMBGF_HOC    hOC,
             NMBGF_FLOAT  ANGLE,
             NMBGF_FLOAT  RADIUS);

        void NMBGF_LINC_PutDALACommand
            (NMBGF_HOC    hOC,
             NMBGF_FLOAT  HEAD,
             NMBGF_FLOAT  RADIUS);

        void NMBGF_LINC_PutDARACommand
            (NMBGF_HOC    hOC,
             NMBGF_FLOAT  HEAD,
             NMBGF_FLOAT  RADIUS);

        void NMBGF_LINC_PutDAPTCommand
            (NMBGF_HOC         hOC,
             NMBGF_COORDINATE  P);

        void NMBGF_LINC_PutDAPHCommand
            (NMBGF_HOC         hOC,
             NMBGF_COORDINATE  P,
             NMBGF_FLOAT       HEAD);

        void NMBGF_LINC_PutMSTRCommand
            (NMBGF_HOC    hOC,
             NMBGF_FLOAT  DIST);

        void NMBGF_LINC_PutMARRCommand
            (NMBGF_HOC    hOC,
             NMBGF_FLOAT  ANGLE,
             NMBGF_FLOAT  RADIUS);

        void NMBGF_LINC_PutMALACommand
            (NMBGF_HOC    hOC,
             NMBGF_FLOAT  HEAD,
             NMBGF_FLOAT  RADIUS);

        void NMBGF_LINC_PutMARACommand
            (NMBGF_HOC    hOC,
             NMBGF_FLOAT  HEAD,
             NMBGF_FLOAT  RADIUS);

        void NMBGF_LINC_PutMAPTCommand
            (NMBGF_HOC         hOC,
             NMBGF_COORDINATE  P);

        void NMBGF_LINC_PutMAPHCommand
            (NMBGF_HOC         hOC,
             NMBGF_COORDINATE  P,
             NMBGF_FLOAT       HEAD);

        void NMBGF_LINC_PutTNRLCommand
            (NMBGF_HOC    hOC,
             NMBGF_FLOAT  ANGLE);

        void NMBGF_LINC_PutTNAHCommand
            (NMBGF_HOC    hOC,
             NMBGF_FLOAT  HEAD);

        void NMBGF_LINC_PutTRFPCommand
            (NMBGF_HOC         hOC,
             NMBGF_COORDINATE  P);

        void NMBGF_LINC_PutTL90Command
            (NMBGF_HOC  hOC);

        void NMBGF_LINC_PutTR90Command
            (NMBGF_HOC  hOC);

        void NMBGF_LINC_PutT180Command
            (NMBGF_HOC  hOC);

    void NMBGF_LINC_CommandsDone
        (NMBGF_HOC  hOC);



void NMBGF_PutLINMSection
    (NMBGF_HOC     hOC,
     NMBGF_STRING  CATAGORY);

        void NMBGF_LINM_BeginPoints
            (NMBGF_HOC  hOC);

            void NMBGF_LINM_PutPoint
                (NMBGF_HOC         hOC,
                 NMBGF_COORDINATE  P);

        void NMBGF_LINM_PointsDone
            (NMBGF_HOC  hOC);

    void NMBGF_LINM_ContinuousLinesDone
        (NMBGF_HOC  hOC);



void NMBGF_PutLINSSection
    (NMBGF_HOC     hOC,
     NMBGF_STRING  CATAGORY);

        void NMBGF_LINS_PutPoint
            (NMBGF_HOC         hOC,
             NMBGF_COORDINATE  P);

    void NMBGF_LINS_PointsDone
        (NMBGF_HOC  hOC);



void NMBGF_PutMTRCSection
    (NMBGF_HOC     hOC,
     NMBGF_STRING  TYPE,
     NMBGF_STRING  UNIT);



void NMBGF_PutPERSSection
    (NMBGF_HOC     hOC,
     NMBGF_STRING  NAME,
     NMBGF_STRING  TITLE,
     NMBGF_STRING  COMPANY,
     NMBGF_STRING  ADDRESS,
     NMBGF_STRING  PHONE,
     NMBGF_STRING  FAX,
     NMBGF_STRING  EMAIL);



void NMBGF_PutPNTMSection
    (NMBGF_HOC     hOC,
     NMBGF_STRING  CATAGORY);

        void NMBGF_PNTM_PutPoint
            (NMBGF_HOC         hOC,
             NMBGF_COORDINATE  P);

    void NMBGF_PNTM_PointsDone
        (NMBGF_HOC  hOC);



void NMBGF_PutPNTSSection
    (NMBGF_HOC         hOC,
     NMBGF_STRING      CATAGORY,
     NMBGF_COORDINATE  P);



void NMBGF_PutPROGSection
    (NMBGF_HOC     hOC,
     NMBGF_STRING  USERNAME,
     NMBGF_STRING  FILENAME,
     NMBGF_FLOAT   VERSION);



void NMBGF_PutSORCSection
    (NMBGF_HOC     hOC,
     NMBGF_STRING  CATAGORY);



void NMBGF_PutSUBGSection
    (NMBGF_HOC      hOC,
     NMBGF_STRING   NAME,
     NMBGF_STRING   PARENT,
     NMBGF_INTEGER  Iparent,
     NMBGF_INTEGER  Jparent,
     NMBGF_INTEGER  NI,
     NMBGF_INTEGER  NJ);

    int NMBGF_SUBG_IsOdd (NMBGF_INTEGER  I);

    void NMBGF_SUBG_PutGridPoint
        (NMBGF_HOC    hOC,
         NMBGF_FLOAT  V);



void NMBGF_PutTIMESection
    (NMBGF_HOC      hOC,
     NMBGF_INTEGER  HOUR,
     NMBGF_INTEGER  MINUTE,
     NMBGF_INTEGER  SECOND);



void NMBGF_PutUTMCSection
    (NMBGF_HOC     hOC,
     NMBGF_INTEGER ZONE,
     NMBGF_FLOAT   FE,
     NMBGF_FLOAT   FN);



void NMBGF_PutWARNSection
    (NMBGF_HOC     hOC,
     NMBGF_STRING  MESSAGE);



typedef enum
    {NMBGF_ZCRD_FeetAboveGroundLevel,
     NMBGF_ZCRD_MetersAboveGroundLevel,
     NMBGF_ZCRD_FeetAboveMeanSeaLevel,
     NMBGF_ZCRD_MetersAboveMeanSeaLevel} NMBGF_ZCRD_UNIT_ENUM;

void NMBGF_PutZCRDSection
    (NMBGF_HOC             hOC,
     NMBGF_FLOAT           Z,
     NMBGF_ZCRD_UNIT_ENUM  UNIT);




#ifdef __cplusplus
    }
#endif




#endif

