/*
 * Decompiled with CFR 0.152.
 */
package hvlnoise;

import Jama.Matrix;
import hvlnoise.Subconductor;
import java.io.Serializable;

public class Conductor
implements Serializable {
    private Matrix positionVector;
    private Subconductor[] subconductors;

    public Conductor(Matrix positionVector, Matrix relSubconductorPositions, Matrix subconductorRadii) {
        this.positionVector = positionVector;
        int numberOfSubconductors = relSubconductorPositions.getColumnDimension();
        this.subconductors = new Subconductor[numberOfSubconductors];
        for (int i = 0; i < numberOfSubconductors; ++i) {
            this.subconductors[i] = new Subconductor(positionVector, relSubconductorPositions.getMatrix(0, 1, i, i), subconductorRadii.get(0, i));
        }
    }

    public double getAbsolutePositionX() {
        return this.positionVector.get(0, 0);
    }

    public double getAbsolutePositionY() {
        return this.positionVector.get(1, 0);
    }

    public Matrix getAbsolutePosition() {
        return this.positionVector;
    }

    public int getNumberOfSubconductors() {
        return this.subconductors.length;
    }

    public double getSubconductorAbsolutePositionX(int subconductorIndex) {
        return this.subconductors[subconductorIndex].getAbsolutePositionX();
    }

    public double getSubconductorAbsolutePositionY(int subconductorIndex) {
        return this.subconductors[subconductorIndex].getAbsolutePositionY();
    }

    public Matrix getSubconductorAbsolutePosition(int subconductorIndex) {
        return this.subconductors[subconductorIndex].getAbsolutePosition();
    }

    public double getSubconductorRelativePositionX(int subconductorIndex) {
        return this.subconductors[subconductorIndex].getRelativePositionX();
    }

    public double getSubconductorRelativePositionY(int subconductorIndex) {
        return this.subconductors[subconductorIndex].getRelativePositionY();
    }

    public double getSubconductorRadius(int subconductorIndex) {
        return this.subconductors[subconductorIndex].getRadius();
    }
}

