/*
 * Decompiled with CFR 0.152.
 */
package hvlnoise;

import hvlnoise.CalculationThread;
import hvlnoise.DecimalNumberVerifier;
import hvlnoise.DecimalNumberVerifierFlag;
import hvlnoise.DecimalNumberVerifierType;
import hvlnoise.HVLNoiseApp;
import hvlnoise.HighVoltageLine;
import hvlnoise.ResultPlot;
import hvlnoise.SoundLevelType;
import java.awt.Frame;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ResourceMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HVLNoisePlotProperties
extends JDialog {
    private HighVoltageLine hvl;
    private CalculationThread calcThread;
    private ArrayList<ResultPlot> resultPlots;
    private boolean calculationMode2Enabled;
    private boolean saveButtonClicked;
    private DecimalNumberVerifierFlag verifierFlag = new DecimalNumberVerifierFlag();
    private JRadioButton audibleNoisePlot;
    private DefaultComboBoxModel conductorModel;
    private JComboBox conductor;
    private JRadioButton electricFieldPlot;
    private DefaultComboBoxModel electricalSystemModel;
    private JComboBox electricalSystem;
    private JButton jButton1;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private ButtonGroup plotGroup;
    private JComboBox soundLevel;
    private DefaultComboBoxModel subconductorModel;
    private JComboBox subconductor;
    private JTextField xMaxPosition;
    private JTextField xMinPosition;
    private JTextField yPosition;

    public HVLNoisePlotProperties(Frame parent, HighVoltageLine hvl, CalculationThread calcThread, ArrayList<ResultPlot> resultPlots, boolean calculationMode2Enabled) {
        super(parent);
        this.initComponents();
        this.hvl = hvl;
        this.calcThread = calcThread;
        this.resultPlots = resultPlots;
        this.calculationMode2Enabled = calculationMode2Enabled;
        for (int i = 0; i < this.hvl.getNumberOfSystems(); ++i) {
            this.electricalSystemModel.addElement("ES" + String.valueOf(i + 1));
        }
        this.setConductorAndSubconductorModel();
        if (this.calculationMode2Enabled) {
            ((DefaultComboBoxModel)this.soundLevel.getModel()).removeElementAt(0);
        }
        this.saveButtonClicked = false;
    }

    public boolean wasSaveButtonClicked() {
        return this.saveButtonClicked;
    }

    private void setConductorAndSubconductorModel() {
        int i;
        int selectedSystem = this.electricalSystem.getSelectedIndex();
        this.conductorModel.removeAllElements();
        for (i = 0; i < this.hvl.getSystem(selectedSystem).getNumberOfConductors(); ++i) {
            this.conductorModel.addElement("Ph" + String.valueOf(i + 1));
        }
        this.subconductorModel.removeAllElements();
        for (i = 0; i < this.hvl.getSystem(selectedSystem).getNumberOfSubconductors(); ++i) {
            this.subconductorModel.addElement("SC" + String.valueOf(i + 1));
        }
    }

    private void onPlotSelectionChange() {
        if (this.electricFieldPlot.isSelected()) {
            this.electricalSystem.setEnabled(true);
            this.conductor.setEnabled(true);
            this.subconductor.setEnabled(true);
            this.soundLevel.setEnabled(false);
            this.yPosition.setEnabled(false);
            this.xMinPosition.setEnabled(false);
            this.xMaxPosition.setEnabled(false);
        }
        if (this.audibleNoisePlot.isSelected()) {
            this.electricalSystem.setEnabled(false);
            this.conductor.setEnabled(false);
            this.subconductor.setEnabled(false);
            this.soundLevel.setEnabled(true);
            this.yPosition.setEnabled(true);
            this.xMinPosition.setEnabled(true);
            this.xMaxPosition.setEnabled(true);
        }
    }

    @Action
    public void savePlotProperties() {
        if (!this.verifierFlag.isVerificationOk()) {
            JOptionPane.showMessageDialog(this, "Some inputs are not valid!", "Invalid inputs", 1);
            return;
        }
        if (this.electricFieldPlot.isSelected()) {
            String systemIndexStr = (String)this.electricalSystemModel.getSelectedItem();
            int systemIndex = Integer.valueOf(systemIndexStr.substring(2, systemIndexStr.length())) - 1;
            String conductorIndexStr = (String)this.conductorModel.getSelectedItem();
            int conductorIndex = Integer.valueOf(conductorIndexStr.substring(2, conductorIndexStr.length())) - 1;
            String subconductorIndexStr = (String)this.subconductorModel.getSelectedItem();
            int subconductorIndex = Integer.valueOf(subconductorIndexStr.substring(2, subconductorIndexStr.length())) - 1;
            ResultPlot plot = new ResultPlot();
            plot.createElectricFieldPlot(this.calcThread.getElectricField(), systemIndex, conductorIndex, subconductorIndex);
            this.resultPlots.add(plot);
        } else {
            if (this.yPosition.getText().equals("") || this.xMinPosition.getText().equals("") || this.xMaxPosition.getText().equals("")) {
                JOptionPane.showMessageDialog(this, "Some parameters were not specified!", "Missing parameters", 1);
                return;
            }
            if (Double.valueOf(this.xMaxPosition.getText()) - 1.0 < Double.valueOf(this.xMinPosition.getText())) {
                JOptionPane.showMessageDialog(this, "xMax should be greater than xMin (at least 1.0m)!", "Invalid input", 1);
                return;
            }
            ResultPlot plot = new ResultPlot();
            if (this.calculationMode2Enabled) {
                switch (this.soundLevel.getSelectedIndex()) {
                    case 0: {
                        plot.createAudibleNoisePlot(this.calcThread.getAudibleNoise(), SoundLevelType.Leq_LEVEL_DURING_RAIN, Double.valueOf(this.yPosition.getText()), Double.valueOf(this.xMinPosition.getText()), Double.valueOf(this.xMaxPosition.getText()));
                        break;
                    }
                    case 1: {
                        plot.createAudibleNoisePlot(this.calcThread.getAudibleNoise(), SoundLevelType.L5_LEVEL, Double.valueOf(this.yPosition.getText()), Double.valueOf(this.xMinPosition.getText()), Double.valueOf(this.xMaxPosition.getText()));
                        break;
                    }
                    case 2: {
                        plot.createAudibleNoisePlot(this.calcThread.getAudibleNoise(), SoundLevelType.L50_LEVEL, Double.valueOf(this.yPosition.getText()), Double.valueOf(this.xMinPosition.getText()), Double.valueOf(this.xMaxPosition.getText()));
                    }
                }
            } else {
                switch (this.soundLevel.getSelectedIndex()) {
                    case 0: {
                        plot.createAudibleNoisePlot(this.calcThread.getAudibleNoise(), SoundLevelType.Leq_LEVEL_DURING_PERIOD, Double.valueOf(this.yPosition.getText()), Double.valueOf(this.xMinPosition.getText()), Double.valueOf(this.xMaxPosition.getText()));
                        break;
                    }
                    case 1: {
                        plot.createAudibleNoisePlot(this.calcThread.getAudibleNoise(), SoundLevelType.Leq_LEVEL_DURING_RAIN, Double.valueOf(this.yPosition.getText()), Double.valueOf(this.xMinPosition.getText()), Double.valueOf(this.xMaxPosition.getText()));
                        break;
                    }
                    case 2: {
                        plot.createAudibleNoisePlot(this.calcThread.getAudibleNoise(), SoundLevelType.L5_LEVEL, Double.valueOf(this.yPosition.getText()), Double.valueOf(this.xMinPosition.getText()), Double.valueOf(this.xMaxPosition.getText()));
                        break;
                    }
                    case 3: {
                        plot.createAudibleNoisePlot(this.calcThread.getAudibleNoise(), SoundLevelType.L50_LEVEL, Double.valueOf(this.yPosition.getText()), Double.valueOf(this.xMinPosition.getText()), Double.valueOf(this.xMaxPosition.getText()));
                    }
                }
            }
            this.resultPlots.add(plot);
        }
        this.saveButtonClicked = true;
        this.closePlotProperties();
    }

    @Action
    public void closePlotProperties() {
        this.dispose();
    }

    private void initComponents() {
        this.plotGroup = new ButtonGroup();
        this.electricFieldPlot = new JRadioButton();
        this.audibleNoisePlot = new JRadioButton();
        this.jLabel1 = new JLabel();
        this.electricalSystemModel = new DefaultComboBoxModel();
        this.electricalSystem = new JComboBox();
        this.jLabel2 = new JLabel();
        this.conductorModel = new DefaultComboBoxModel();
        this.conductor = new JComboBox();
        this.jLabel3 = new JLabel();
        this.subconductorModel = new DefaultComboBoxModel();
        this.subconductor = new JComboBox();
        this.jLabel4 = new JLabel();
        this.soundLevel = new JComboBox();
        this.jLabel5 = new JLabel();
        this.yPosition = new JTextField();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.xMinPosition = new JTextField();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.xMaxPosition = new JTextField();
        this.jLabel10 = new JLabel();
        this.jButton1 = new JButton();
        this.setDefaultCloseOperation(2);
        ResourceMap resourceMap = Application.getInstance(HVLNoiseApp.class).getContext().getResourceMap(HVLNoisePlotProperties.class);
        this.setTitle(resourceMap.getString("HVLNoisePlotProperties.title", new Object[0]));
        this.setIconImage(null);
        this.setModal(true);
        this.setName("HVLNoisePlotProperties");
        this.setResizable(false);
        this.plotGroup.add(this.electricFieldPlot);
        this.electricFieldPlot.setSelected(true);
        this.electricFieldPlot.setText(resourceMap.getString("electricFieldPlot.text", new Object[0]));
        this.electricFieldPlot.setName("electricFieldPlot");
        this.electricFieldPlot.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                HVLNoisePlotProperties.this.electricFieldPlotItemStateChanged(evt);
            }
        });
        this.plotGroup.add(this.audibleNoisePlot);
        this.audibleNoisePlot.setText(resourceMap.getString("audibleNoisePlot.text", new Object[0]));
        this.audibleNoisePlot.setName("audibleNoisePlot");
        this.audibleNoisePlot.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                HVLNoisePlotProperties.this.audibleNoisePlotItemStateChanged(evt);
            }
        });
        this.jLabel1.setText(resourceMap.getString("jLabel1.text", new Object[0]));
        this.jLabel1.setName("jLabel1");
        this.electricalSystem.setModel(this.electricalSystemModel);
        this.electricalSystem.setName("electricalSystem");
        this.electricalSystem.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                HVLNoisePlotProperties.this.electricalSystemItemStateChanged(evt);
            }
        });
        this.jLabel2.setText(resourceMap.getString("jLabel2.text", new Object[0]));
        this.jLabel2.setName("jLabel2");
        this.conductor.setModel(this.conductorModel);
        this.conductor.setName("conductor");
        this.jLabel3.setText(resourceMap.getString("jLabel3.text", new Object[0]));
        this.jLabel3.setName("jLabel3");
        this.subconductor.setModel(this.subconductorModel);
        this.subconductor.setName("subconductor");
        this.jLabel4.setText(resourceMap.getString("jLabel4.text", new Object[0]));
        this.jLabel4.setName("jLabel4");
        this.soundLevel.setModel(new DefaultComboBoxModel<String>(new String[]{"Leq during Period", "Leq during Rain", "L5", "L50"}));
        this.soundLevel.setEnabled(false);
        this.soundLevel.setName("soundLevel");
        this.jLabel5.setText(resourceMap.getString("jLabel5.text", new Object[0]));
        this.jLabel5.setName("jLabel5");
        this.yPosition.setEnabled(false);
        this.yPosition.setInputVerifier(new DecimalNumberVerifier(DecimalNumberVerifierType.POSITIVE_DECIMAL_NUMBER_WITH_ZERO, this.verifierFlag));
        this.yPosition.setName("yPosition");
        this.jLabel6.setText(resourceMap.getString("jLabel6.text", new Object[0]));
        this.jLabel6.setName("jLabel6");
        this.jLabel7.setText(resourceMap.getString("jLabel7.text", new Object[0]));
        this.jLabel7.setName("jLabel7");
        this.xMinPosition.setEnabled(false);
        this.xMinPosition.setInputVerifier(new DecimalNumberVerifier(DecimalNumberVerifierType.DECIMAL_NUMBER, this.verifierFlag));
        this.xMinPosition.setName("xMinPosition");
        this.jLabel8.setText(resourceMap.getString("jLabel8.text", new Object[0]));
        this.jLabel8.setName("jLabel8");
        this.jLabel9.setText(resourceMap.getString("jLabel9.text", new Object[0]));
        this.jLabel9.setName("jLabel9");
        this.xMaxPosition.setEnabled(false);
        this.xMaxPosition.setInputVerifier(new DecimalNumberVerifier(DecimalNumberVerifierType.DECIMAL_NUMBER, this.verifierFlag));
        this.xMaxPosition.setName("xMaxPosition");
        this.jLabel10.setText(resourceMap.getString("jLabel10.text", new Object[0]));
        this.jLabel10.setName("jLabel10");
        ApplicationActionMap actionMap = Application.getInstance(HVLNoiseApp.class).getContext().getActionMap(HVLNoisePlotProperties.class, this);
        this.jButton1.setAction(actionMap.get("savePlotProperties"));
        this.jButton1.setText(resourceMap.getString("jButton1.text", new Object[0]));
        this.jButton1.setName("jButton1");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.electricFieldPlot).addGroup(layout.createSequentialGroup().addGap(21, 21, 21).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.conductor, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.electricalSystem, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.subconductor, -2, -1, -2)))).addComponent(this.audibleNoisePlot).addGroup(layout.createSequentialGroup().addGap(21, 21, 21).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.yPosition, -2, 40, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel6)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.soundLevel, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.xMinPosition, -2, 40, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel8).addGap(18, 18, 18).addComponent(this.jLabel9).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.xMaxPosition, -2, 40, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel10)))))).addGroup(layout.createSequentialGroup().addGap(83, 83, 83).addComponent(this.jButton1))).addContainerGap(12, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.electricFieldPlot).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.electricalSystem, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.conductor, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.subconductor, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.audibleNoisePlot).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.soundLevel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.yPosition, -2, -1, -2).addComponent(this.jLabel6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.xMinPosition, -2, -1, -2).addComponent(this.jLabel8).addComponent(this.jLabel9).addComponent(this.xMaxPosition, -2, -1, -2).addComponent(this.jLabel10)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButton1).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void electricalSystemItemStateChanged(ItemEvent evt) {
        this.setConductorAndSubconductorModel();
    }

    private void electricFieldPlotItemStateChanged(ItemEvent evt) {
        this.onPlotSelectionChange();
    }

    private void audibleNoisePlotItemStateChanged(ItemEvent evt) {
        this.onPlotSelectionChange();
    }
}

