/*
 * Decompiled with CFR 0.152.
 */
package hvlnoise;

import hvlnoise.AudibleNoise;
import hvlnoise.CalculationThread;
import hvlnoise.DecimalNumberVerifier;
import hvlnoise.DecimalNumberVerifierFlag;
import hvlnoise.DecimalNumberVerifierType;
import hvlnoise.ElectricField;
import hvlnoise.ElectricalSystem;
import hvlnoise.HVLNoiseAboutBox;
import hvlnoise.HVLNoiseApp;
import hvlnoise.HVLNoiseCalculationProgress;
import hvlnoise.HVLNoiseExplanationsBox;
import hvlnoise.HVLNoisePlotProperties;
import hvlnoise.HVLNoiseSystemProperties;
import hvlnoise.HighVoltageLine;
import hvlnoise.ResultPlot;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileFilter;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ResourceMap;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartFrame;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.DatasetRenderingOrder;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYZDataset;

public class HVLNoiseView
extends JFrame {
    private JFreeChart chart;
    private HighVoltageLine hvl;
    private CalculationThread calcThread;
    private ArrayList<ResultPlot> resultPlots;
    private DecimalNumberVerifierFlag verifierFlag = new DecimalNumberVerifierFlag();
    private JTextField R50RainRate;
    private JTextField R5RainRate;
    private JMenuItem aboutMenuItem;
    private JButton addPlotButton;
    private JButton addSystemButton;
    private JPanel audibleNoisePanel;
    private JButton calculateButton;
    private JComboBox calculationAccuracy;
    private JRadioButton calculationMode1;
    private JRadioButton calculationMode2;
    private ButtonGroup calculationModeGroup;
    private JPanel chartPanel;
    private JMenuItem explanationsMenuItem;
    private JMenu exportMenu;
    private JPanel hvlPanel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSeparator jSeparator1;
    private JPanel mainPanel;
    private JMenuBar menuBar;
    private JButton modifySystemButton;
    private JMenuItem newMenuItem;
    private JMenuItem openMenuItem;
    private JTextField percentageOfRain;
    private DefaultListModel plotListModel;
    private JList plotList;
    private JPanel plotPanel;
    private JTextField rainRate;
    private JButton removePlotButton;
    private JButton removeSystemButton;
    private JMenuItem saveMenuItem;
    private JButton showPlotButton;
    private DefaultListModel systemListModel;
    private JList systemList;
    private JPanel systemsPanel;

    public HVLNoiseView() {
        this.hvl = new HighVoltageLine();
        this.initChart();
        this.initComponents();
        this.resultPlots = new ArrayList();
        ArrayList<Image> images = new ArrayList<Image>();
        URL imageURL1 = HVLNoiseView.class.getResource("resources/icon16x16.png");
        URL imageURL2 = HVLNoiseView.class.getResource("resources/icon32x32.png");
        URL imageURL3 = HVLNoiseView.class.getResource("resources/icon48x48.png");
        if (imageURL1 != null && imageURL2 != null && imageURL3 != null) {
            ImageIcon icon1 = new ImageIcon(imageURL1);
            ImageIcon icon2 = new ImageIcon(imageURL2);
            ImageIcon icon3 = new ImageIcon(imageURL3);
            images.add(icon1.getImage());
            images.add(icon2.getImage());
            images.add(icon3.getImage());
            this.setIconImages(images);
        }
    }

    private void initChart() {
        this.chart = ChartFactory.createBubbleChart(null, (String)"x [m]", (String)"y [m]", (XYZDataset)this.hvl.getDefaultXYZDataset(), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
        this.chart.getXYPlot().setDataset(1, (XYDataset)this.hvl.getXYDefaultDataset());
        XYPlot plot = this.chart.getXYPlot();
        plot.setBackgroundPaint((Paint)Color.white);
        plot.setDomainGridlinePaint((Paint)Color.black);
        plot.setRangeGridlinePaint((Paint)Color.black);
        plot.setOutlinePaint((Paint)Color.black);
        plot.getDomainAxis().setAutoRangeMinimumSize(1.0);
        plot.getRangeAxis().setAutoRangeMinimumSize(1.0);
    }

    private void onCalculationModeChange() {
        if (this.calculationMode1.isSelected()) {
            this.R5RainRate.setEnabled(true);
            this.R50RainRate.setEnabled(true);
            this.percentageOfRain.setEnabled(true);
            this.rainRate.setEnabled(false);
        }
        if (this.calculationMode2.isSelected()) {
            this.R5RainRate.setEnabled(false);
            this.R50RainRate.setEnabled(false);
            this.percentageOfRain.setEnabled(false);
            this.rainRate.setEnabled(true);
        }
    }

    @Action
    public void addElectricalSystem() {
        HVLNoiseSystemProperties systemProperties = new HVLNoiseSystemProperties((Frame)this, this.hvl, null);
        systemProperties.setLocationRelativeTo(this);
        systemProperties.setVisible(true);
        if (systemProperties.wasSaveButtonClicked()) {
            int numberOfItems = this.systemListModel.getSize();
            ElectricalSystem system = this.hvl.getSystem(numberOfItems);
            String sysString = "";
            switch (system.getSystemType()) {
                case AC_THREE_PHASE_SYSTEM: {
                    sysString = "(AC Three Phase, " + String.valueOf(system.getACSystemVoltage()) + "kV, 50.0Hz)";
                    break;
                }
                case AC_SINGLE_PHASE_SYSTEM: {
                    sysString = "(AC Single Phase, " + String.valueOf(system.getACSystemVoltage()) + "kV, 16.7Hz)";
                    break;
                }
                case DC_TWO_PHASE_SYSTEM: {
                    sysString = "(DC Two Phase, " + String.valueOf(system.getDCSystemVoltage(0)) + "kV, " + String.valueOf(system.getDCSystemVoltage(1)) + "kV)";
                }
            }
            this.systemListModel.add(numberOfItems, "ES" + String.valueOf(numberOfItems + 1) + " " + sysString);
            this.systemList.setSelectedIndex(numberOfItems);
            this.systemList.ensureIndexIsVisible(numberOfItems);
            this.chart.getXYPlot().setRenderer((XYItemRenderer)this.hvl.getXYBubbleRenderer());
            this.chart.getXYPlot().setRenderer(1, (XYItemRenderer)this.hvl.getXYDotRenderer());
            this.chart.getXYPlot().setDatasetRenderingOrder(DatasetRenderingOrder.FORWARD);
            this.calculateButton.setEnabled(true);
        }
    }

    @Action
    public void modifyElectricalSystem() {
        int systemIndex = this.systemList.getSelectedIndex();
        if (systemIndex < 0) {
            return;
        }
        HVLNoiseSystemProperties systemProperties = new HVLNoiseSystemProperties((Frame)this, this.hvl, this.hvl.getSystem(systemIndex));
        systemProperties.setLocationRelativeTo(this);
        systemProperties.setVisible(true);
        if (systemProperties.wasSaveButtonClicked()) {
            ElectricalSystem system = this.hvl.getSystem(systemIndex);
            String sysString = "";
            switch (system.getSystemType()) {
                case AC_THREE_PHASE_SYSTEM: {
                    sysString = "(AC Three Phase, " + String.valueOf(system.getACSystemVoltage()) + "kV, 50.0Hz)";
                    break;
                }
                case AC_SINGLE_PHASE_SYSTEM: {
                    sysString = "(AC Single Phase, " + String.valueOf(system.getACSystemVoltage()) + "kV, 16.7Hz)";
                    break;
                }
                case DC_TWO_PHASE_SYSTEM: {
                    sysString = "(DC Two Phase, " + String.valueOf(system.getDCSystemVoltage(0)) + "kV, " + String.valueOf(system.getDCSystemVoltage(1)) + "kV)";
                }
            }
            this.systemListModel.set(systemIndex, "ES" + String.valueOf(systemIndex + 1) + " " + sysString);
            this.systemList.setSelectedIndex(systemIndex);
            this.systemList.ensureIndexIsVisible(systemIndex);
            this.chart.getXYPlot().setRenderer((XYItemRenderer)this.hvl.getXYBubbleRenderer());
            this.chart.getXYPlot().setRenderer(1, (XYItemRenderer)this.hvl.getXYDotRenderer());
            this.chart.getXYPlot().setDatasetRenderingOrder(DatasetRenderingOrder.FORWARD);
        }
    }

    @Action
    public void removeElectricalSystem() {
        int systemIndex = this.systemList.getSelectedIndex();
        if (systemIndex < 0) {
            return;
        }
        this.hvl.removeSystem(systemIndex);
        this.systemListModel.remove(systemIndex);
        for (int i = 0; i < this.systemListModel.getSize(); ++i) {
            String newListStr = ((String)this.systemListModel.get(i)).replaceFirst("ES[0-9]+ ", "ES" + String.valueOf(i + 1) + " ");
            this.systemListModel.set(i, newListStr);
        }
        this.systemList.setSelectedIndex(0);
        this.systemList.ensureIndexIsVisible(0);
        this.chart.getXYPlot().setRenderer((XYItemRenderer)this.hvl.getXYBubbleRenderer());
        this.chart.getXYPlot().setRenderer(1, (XYItemRenderer)this.hvl.getXYDotRenderer());
        this.chart.getXYPlot().setDatasetRenderingOrder(DatasetRenderingOrder.FORWARD);
        if (this.systemListModel.size() == 0) {
            this.calculateButton.setEnabled(false);
        }
    }

    @Action
    public void calculateAudibleNoise() {
        double rainPercentage;
        double rainRateL50;
        double rainRateL5;
        if (!this.verifierFlag.isVerificationOk()) {
            JOptionPane.showMessageDialog(this, "Some inputs are not valid!", "Invalid inputs", 1);
            return;
        }
        if (this.calculateButton.getText().equals("New")) {
            this.hvl.removeSoundPowerLevelAnnotations();
            this.addSystemButton.setEnabled(true);
            this.modifySystemButton.setEnabled(true);
            this.removeSystemButton.setEnabled(true);
            this.calculationMode1.setEnabled(true);
            this.calculationMode2.setEnabled(true);
            if (this.calculationMode1.isSelected()) {
                this.R5RainRate.setEnabled(true);
                this.R50RainRate.setEnabled(true);
                this.percentageOfRain.setEnabled(true);
            }
            if (this.calculationMode2.isSelected()) {
                this.rainRate.setEnabled(true);
            }
            this.calculationAccuracy.setEnabled(true);
            this.calculateButton.setText("Calculate");
            this.addPlotButton.setEnabled(false);
            this.removePlotButton.setEnabled(false);
            this.showPlotButton.setEnabled(false);
            return;
        }
        if (this.calculationMode1.isSelected() && (this.R5RainRate.getText().equals("") || this.R50RainRate.getText().equals("") || this.percentageOfRain.getText().equals(""))) {
            JOptionPane.showMessageDialog(this, "Some parameters were not specified!", "Missing parameters", 1);
            return;
        }
        if (this.calculationMode2.isSelected() && this.rainRate.getText().equals("")) {
            JOptionPane.showMessageDialog(this, "Some parameters were not specified!", "Missing parameters", 1);
            return;
        }
        HVLNoiseCalculationProgress calculationProgress = new HVLNoiseCalculationProgress(this);
        calculationProgress.setLocationRelativeTo(this);
        JProgressBar calculationProgressBar = calculationProgress.getCalculationProgressBar();
        String strAccuracy = (String)this.calculationAccuracy.getModel().getSelectedItem();
        double accuracy = 0.01;
        if (strAccuracy.equals("lowest")) {
            accuracy = 0.04;
        } else if (strAccuracy.equals("low")) {
            accuracy = 0.02;
        } else if (strAccuracy.equals("medium")) {
            accuracy = 0.01;
        } else if (strAccuracy.equals("high")) {
            accuracy = 0.005;
        } else if (strAccuracy.equals("highest")) {
            accuracy = 0.0025;
        }
        if (this.calculationMode1.isSelected()) {
            rainRateL5 = Double.valueOf(this.R5RainRate.getText());
            rainRateL50 = Double.valueOf(this.R50RainRate.getText());
            rainPercentage = Double.valueOf(this.percentageOfRain.getText());
        } else {
            rainRateL50 = rainRateL5 = Double.valueOf(this.rainRate.getText()).doubleValue();
            rainPercentage = 100.0;
        }
        this.calcThread = new CalculationThread(calculationProgress, calculationProgressBar, this.hvl, accuracy, rainRateL5, rainRateL50, rainPercentage);
        this.calcThread.start();
        calculationProgress.setVisible(true);
        if (this.calcThread.wasExceptionThrown()) {
            JOptionPane.showMessageDialog(this, "An error occurred during calculation! Please check your high voltage line specification!", "Error", 0);
            return;
        }
        this.addSystemButton.setEnabled(false);
        this.modifySystemButton.setEnabled(false);
        this.removeSystemButton.setEnabled(false);
        this.calculationMode1.setEnabled(false);
        this.calculationMode2.setEnabled(false);
        if (this.calculationMode1.isSelected()) {
            this.R5RainRate.setEnabled(false);
            this.R50RainRate.setEnabled(false);
            this.percentageOfRain.setEnabled(false);
        }
        if (this.calculationMode2.isSelected()) {
            this.rainRate.setEnabled(false);
        }
        this.calculationAccuracy.setEnabled(false);
        this.calculateButton.setText("New");
        this.addPlotButton.setEnabled(true);
        this.removePlotButton.setEnabled(true);
        this.showPlotButton.setEnabled(true);
    }

    @Action
    public void addResultPlot() {
        HVLNoisePlotProperties plotProperties = new HVLNoisePlotProperties(this, this.hvl, this.calcThread, this.resultPlots, this.calculationMode2.isSelected());
        plotProperties.setLocationRelativeTo(this);
        plotProperties.setVisible(true);
        if (plotProperties.wasSaveButtonClicked()) {
            ResultPlot plot = this.resultPlots.get(this.resultPlots.size() - 1);
            String plotStr = "";
            switch (plot.getResultPlotType()) {
                case ELECTRIC_FIELD_PLOT: {
                    plotStr = "(Electric Field, ES" + String.valueOf(plot.getSystemIndex() + 1) + ", Ph" + String.valueOf(plot.getConductorIndex() + 1) + ", SC" + String.valueOf(plot.getSubconductorIndex() + 1) + ")";
                    break;
                }
                case AUDIBLE_NOISE_PLOT: {
                    plotStr = "(Audible Noise, ";
                    switch (plot.getSoundPressureLevelType()) {
                        case L5_LEVEL: {
                            plotStr = plotStr + "L5 Level, ";
                            break;
                        }
                        case L50_LEVEL: {
                            plotStr = plotStr + "L50 Level, ";
                            break;
                        }
                        case Leq_LEVEL_DURING_RAIN: {
                            plotStr = plotStr + "Leq Level during Rain, ";
                            break;
                        }
                        case Leq_LEVEL_DURING_PERIOD: {
                            plotStr = plotStr + "Leq Level during Period, ";
                        }
                    }
                    plotStr = plotStr + "y=" + String.valueOf(plot.getYPosition()) + "m, xMin=" + String.valueOf(plot.getXPositionMin()) + "m, xMax=" + String.valueOf(plot.getXPositionMax()) + "m)";
                }
            }
            this.plotListModel.addElement("Plot" + String.valueOf(this.resultPlots.size()) + " " + plotStr);
            this.plotList.setSelectedIndex(this.plotListModel.getSize() - 1);
            this.plotList.ensureIndexIsVisible(this.plotListModel.size() - 1);
            JMenuItem exportMenuItem = new JMenuItem();
            exportMenuItem.setText("Plot" + String.valueOf(this.resultPlots.size()));
            final int plotIndex1 = this.resultPlots.size() - 1;
            exportMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    HVLNoiseView.this.exportPlot(plotIndex1);
                }
            });
            this.exportMenu.add(exportMenuItem);
            this.exportMenu.setEnabled(true);
            ChartFrame chartFrame = this.resultPlots.get(this.resultPlots.size() - 1).getChartFrame();
            ArrayList<Image> images = new ArrayList<Image>();
            URL imageURL1 = HVLNoiseView.class.getResource("resources/icon16x16.png");
            URL imageURL2 = HVLNoiseView.class.getResource("resources/icon32x32.png");
            URL imageURL3 = HVLNoiseView.class.getResource("resources/icon48x48.png");
            if (imageURL1 != null && imageURL2 != null && imageURL3 != null) {
                ImageIcon icon1 = new ImageIcon(imageURL1);
                ImageIcon icon2 = new ImageIcon(imageURL2);
                ImageIcon icon3 = new ImageIcon(imageURL3);
                images.add(icon1.getImage());
                images.add(icon2.getImage());
                images.add(icon3.getImage());
                chartFrame.setIconImages(images);
            }
            chartFrame.setLocationRelativeTo((Component)this);
            chartFrame.setVisible(true);
        }
    }

    @Action
    public void removeResultPlot() {
        int plotIndex = this.plotList.getSelectedIndex();
        if (plotIndex < 0) {
            return;
        }
        this.resultPlots.remove(plotIndex);
        this.plotListModel.remove(plotIndex);
        this.exportMenu.removeAll();
        if (this.plotListModel.size() == 0) {
            this.exportMenu.setEnabled(false);
        }
        int i = 0;
        while (i < this.plotListModel.getSize()) {
            String newListStr = ((String)this.plotListModel.get(i)).replaceFirst("Plot[0-9]+ ", "Plot" + String.valueOf(i + 1) + " ");
            this.plotListModel.set(i, newListStr);
            JMenuItem exportMenuItem = new JMenuItem();
            exportMenuItem.setText("Plot" + String.valueOf(i + 1));
            final int plotIndex2 = i++;
            exportMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    HVLNoiseView.this.exportPlot(plotIndex2);
                }
            });
            this.exportMenu.add(exportMenuItem);
        }
        this.plotList.setSelectedIndex(0);
        this.plotList.ensureIndexIsVisible(0);
    }

    @Action
    public void showResultPlot() {
        int plotIndex = this.plotList.getSelectedIndex();
        if (plotIndex < 0) {
            return;
        }
        ChartFrame chartFrame = this.resultPlots.get(plotIndex).getChartFrame();
        ArrayList<Image> images = new ArrayList<Image>();
        URL imageURL1 = HVLNoiseView.class.getResource("resources/icon16x16.png");
        URL imageURL2 = HVLNoiseView.class.getResource("resources/icon32x32.png");
        URL imageURL3 = HVLNoiseView.class.getResource("resources/icon48x48.png");
        if (imageURL1 != null && imageURL2 != null && imageURL3 != null) {
            ImageIcon icon1 = new ImageIcon(imageURL1);
            ImageIcon icon2 = new ImageIcon(imageURL2);
            ImageIcon icon3 = new ImageIcon(imageURL3);
            images.add(icon1.getImage());
            images.add(icon2.getImage());
            images.add(icon3.getImage());
            chartFrame.setIconImages(images);
        }
        chartFrame.setLocationRelativeTo((Component)this);
        chartFrame.setVisible(true);
    }

    @Action
    public void newFile() {
        if (JOptionPane.showConfirmDialog(this, "Do you want to open a new session? Unsaved data will be lost!", "New", 0, 3) == 0) {
            this.hvl = new HighVoltageLine();
            this.initChart();
            ((ChartPanel)this.chartPanel).setChart(this.chart);
            this.calcThread = null;
            this.resultPlots = new ArrayList();
            this.verifierFlag = new DecimalNumberVerifierFlag();
            this.systemListModel = new DefaultListModel();
            this.systemList.setModel(this.systemListModel);
            this.addSystemButton.setEnabled(true);
            this.modifySystemButton.setEnabled(true);
            this.removeSystemButton.setEnabled(true);
            this.calculationMode1.setSelected(true);
            this.calculationMode1.setEnabled(true);
            this.R5RainRate.setText("");
            this.R5RainRate.setEnabled(true);
            this.R50RainRate.setText("");
            this.R50RainRate.setEnabled(true);
            this.percentageOfRain.setText("");
            this.percentageOfRain.setEnabled(true);
            this.calculationMode2.setSelected(false);
            this.calculationMode2.setEnabled(true);
            this.rainRate.setText("");
            this.rainRate.setEnabled(false);
            this.calculationAccuracy.setSelectedIndex(2);
            this.calculationAccuracy.setEnabled(true);
            this.calculateButton.setText("Calculate");
            this.calculateButton.setEnabled(true);
            this.plotListModel = new DefaultListModel();
            this.plotList.setModel(this.plotListModel);
            this.addPlotButton.setEnabled(false);
            this.removePlotButton.setEnabled(false);
            this.showPlotButton.setEnabled(false);
            this.exportMenu.removeAll();
            this.exportMenu.setEnabled(false);
        }
    }

    @Action
    public void openFile() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                String fileName = file.getName();
                return fileName.length() >= 9 && fileName.substring(fileName.length() - 9, fileName.length()).equals(".hvlnoise");
            }

            public String getDescription() {
                return "HVLNoise Session (.hvlnoise)";
            }
        });
        if (fileChooser.showOpenDialog(this) == 0) {
            Object inputObject31;
            Object inputObject30;
            Object inputObject29;
            Object inputObject28;
            Object inputObject27;
            Object inputObject26;
            Object inputObject25;
            Object inputObject24;
            Object inputObject23;
            Object inputObject22;
            Object inputObject21;
            Object inputObject20;
            Object inputObject19;
            Object inputObject18;
            Object inputObject17;
            Object inputObject16;
            Object inputObject15;
            Object inputObject14;
            Object inputObject13;
            Object inputObject12;
            Object inputObject11;
            Object inputObject10;
            Object inputObject9;
            Object inputObject8;
            Object inputObject7;
            Object inputObject6;
            Object inputObject5;
            Object inputObject4;
            Object inputObject3;
            Object inputObject2;
            Object inputObject1;
            String fileName = fileChooser.getSelectedFile().getAbsolutePath();
            if (fileName.length() < 9 || !fileName.substring(fileName.length() - 9, fileName.length()).equals(".hvlnoise")) {
                fileName = fileName + ".hvlnoise";
            }
            try {
                ObjectInputStream objectInput = new ObjectInputStream(new FileInputStream(fileName));
                inputObject1 = objectInput.readObject();
                inputObject2 = objectInput.readObject();
                inputObject3 = objectInput.readObject();
                inputObject4 = objectInput.readObject();
                inputObject5 = objectInput.readObject();
                inputObject6 = objectInput.readObject();
                inputObject7 = objectInput.readObject();
                inputObject8 = objectInput.readObject();
                inputObject9 = objectInput.readObject();
                inputObject10 = objectInput.readObject();
                inputObject11 = objectInput.readObject();
                inputObject12 = objectInput.readObject();
                inputObject13 = objectInput.readObject();
                inputObject14 = objectInput.readObject();
                inputObject15 = objectInput.readObject();
                inputObject16 = objectInput.readObject();
                inputObject17 = objectInput.readObject();
                inputObject18 = objectInput.readObject();
                inputObject19 = objectInput.readObject();
                inputObject20 = objectInput.readObject();
                inputObject21 = objectInput.readObject();
                inputObject22 = objectInput.readObject();
                inputObject23 = objectInput.readObject();
                inputObject24 = objectInput.readObject();
                inputObject25 = objectInput.readObject();
                inputObject26 = objectInput.readObject();
                inputObject27 = objectInput.readObject();
                inputObject28 = objectInput.readObject();
                inputObject29 = objectInput.readObject();
                inputObject30 = objectInput.readObject();
                inputObject31 = objectInput.readObject();
                objectInput.close();
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, "The input file could not be read!", "File error", 0);
                return;
            }
            this.chart = (JFreeChart)inputObject1;
            ((ChartPanel)this.chartPanel).setChart(this.chart);
            this.hvl = (HighVoltageLine)inputObject2;
            this.calcThread = new CalculationThread();
            this.calcThread.setElectricField((ElectricField)inputObject3);
            this.calcThread.setAudibleNoise((AudibleNoise)inputObject4);
            this.resultPlots = (ArrayList)inputObject5;
            this.systemListModel = (DefaultListModel)inputObject6;
            this.systemList.setModel(this.systemListModel);
            int systemSelectedIndex = (Integer)inputObject7;
            this.systemList.setSelectedIndex(systemSelectedIndex);
            this.systemList.ensureIndexIsVisible(systemSelectedIndex);
            this.addSystemButton.setEnabled((Boolean)inputObject8);
            this.modifySystemButton.setEnabled((Boolean)inputObject9);
            this.removeSystemButton.setEnabled((Boolean)inputObject10);
            this.calculationMode1.setSelected((Boolean)inputObject11);
            this.calculationMode1.setEnabled((Boolean)inputObject12);
            this.R5RainRate.setText((String)inputObject13);
            this.R5RainRate.setEnabled((Boolean)inputObject14);
            this.R50RainRate.setText((String)inputObject15);
            this.R50RainRate.setEnabled((Boolean)inputObject16);
            this.percentageOfRain.setText((String)inputObject17);
            this.percentageOfRain.setEnabled((Boolean)inputObject18);
            this.calculationMode2.setSelected((Boolean)inputObject19);
            this.calculationMode2.setEnabled((Boolean)inputObject20);
            this.rainRate.setText((String)inputObject21);
            this.rainRate.setEnabled((Boolean)inputObject22);
            this.calculationAccuracy.setSelectedIndex((Integer)inputObject23);
            this.calculationAccuracy.setEnabled((Boolean)inputObject24);
            this.calculateButton.setText((String)inputObject25);
            this.calculateButton.setEnabled((Boolean)inputObject26);
            this.plotListModel = (DefaultListModel)inputObject27;
            this.plotList.setModel(this.plotListModel);
            int plotSelectedIndex = (Integer)inputObject28;
            this.plotList.setSelectedIndex(plotSelectedIndex);
            this.plotList.ensureIndexIsVisible(plotSelectedIndex);
            this.addPlotButton.setEnabled((Boolean)inputObject29);
            this.removePlotButton.setEnabled((Boolean)inputObject30);
            this.showPlotButton.setEnabled((Boolean)inputObject31);
            this.exportMenu.removeAll();
            if (this.plotListModel.size() == 0) {
                this.exportMenu.setEnabled(false);
            } else {
                this.exportMenu.setEnabled(true);
            }
            int i = 0;
            while (i < this.plotListModel.getSize()) {
                JMenuItem exportMenuItem = new JMenuItem();
                exportMenuItem.setText("Plot" + String.valueOf(i + 1));
                final int plotIndex = i++;
                exportMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent event) {
                        HVLNoiseView.this.exportPlot(plotIndex);
                    }
                });
                this.exportMenu.add(exportMenuItem);
            }
        }
    }

    @Action
    public void saveFile() {
        if (!this.verifierFlag.isVerificationOk()) {
            JOptionPane.showMessageDialog(this, "Some inputs are not valid!", "Invalid inputs", 1);
            return;
        }
        final HVLNoiseView mainFrame = this;
        JFileChooser fileChooser = new JFileChooser(){

            public void approveSelection() {
                int answer;
                File file = this.getSelectedFile();
                if (file != null && file.exists() && ((answer = JOptionPane.showConfirmDialog(mainFrame, "File already exists! Do you want to overwrite it?", "File warning", 0, 2)) == 1 || answer == -1)) {
                    return;
                }
                super.approveSelection();
            }
        };
        fileChooser.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                String fileName = file.getName();
                return fileName.length() >= 9 && fileName.substring(fileName.length() - 9, fileName.length()).equals(".hvlnoise");
            }

            public String getDescription() {
                return "HVLNoise Session (.hvlnoise)";
            }
        });
        if (fileChooser.showSaveDialog(this) == 0) {
            String fileName = fileChooser.getSelectedFile().getAbsolutePath();
            if (fileName.length() < 9 || !fileName.substring(fileName.length() - 9, fileName.length()).equals(".hvlnoise")) {
                fileName = fileName + ".hvlnoise";
            }
            try {
                ObjectOutputStream objectOutput = new ObjectOutputStream(new FileOutputStream(fileName));
                objectOutput.writeObject(this.chart);
                objectOutput.writeObject(this.hvl);
                if (this.calcThread == null) {
                    this.calcThread = new CalculationThread();
                }
                objectOutput.writeObject(this.calcThread.getElectricField());
                objectOutput.writeObject(this.calcThread.getAudibleNoise());
                objectOutput.writeObject(this.resultPlots);
                objectOutput.writeObject(this.systemListModel);
                objectOutput.writeObject(this.systemList.getSelectedIndex());
                objectOutput.writeObject(this.addSystemButton.isEnabled());
                objectOutput.writeObject(this.modifySystemButton.isEnabled());
                objectOutput.writeObject(this.removeSystemButton.isEnabled());
                objectOutput.writeObject(this.calculationMode1.isSelected());
                objectOutput.writeObject(this.calculationMode1.isEnabled());
                objectOutput.writeObject(this.R5RainRate.getText());
                objectOutput.writeObject(this.R5RainRate.isEnabled());
                objectOutput.writeObject(this.R50RainRate.getText());
                objectOutput.writeObject(this.R50RainRate.isEnabled());
                objectOutput.writeObject(this.percentageOfRain.getText());
                objectOutput.writeObject(this.percentageOfRain.isEnabled());
                objectOutput.writeObject(this.calculationMode2.isSelected());
                objectOutput.writeObject(this.calculationMode2.isEnabled());
                objectOutput.writeObject(this.rainRate.getText());
                objectOutput.writeObject(this.rainRate.isEnabled());
                objectOutput.writeObject(this.calculationAccuracy.getSelectedIndex());
                objectOutput.writeObject(this.calculationAccuracy.isEnabled());
                objectOutput.writeObject(this.calculateButton.getText());
                objectOutput.writeObject(this.calculateButton.isEnabled());
                objectOutput.writeObject(this.plotListModel);
                objectOutput.writeObject(this.plotList.getSelectedIndex());
                objectOutput.writeObject(this.addPlotButton.isEnabled());
                objectOutput.writeObject(this.removePlotButton.isEnabled());
                objectOutput.writeObject(this.showPlotButton.isEnabled());
                objectOutput.close();
            }
            catch (IOException ioException) {
                JOptionPane.showMessageDialog(this, "The output file could not be written!", "File error", 0);
            }
        }
    }

    @Action
    public void exportPlot(int plotIndex) {
        final HVLNoiseView mainFrame = this;
        JFileChooser fileChooser = new JFileChooser(){

            public void approveSelection() {
                int answer;
                File file = this.getSelectedFile();
                if (file != null && file.exists() && ((answer = JOptionPane.showConfirmDialog(mainFrame, "File already exists! Do you want to overwrite it?", "File warning", 0, 2)) == 1 || answer == -1)) {
                    return;
                }
                super.approveSelection();
            }
        };
        fileChooser.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                String fileName = file.getName();
                return fileName.length() >= 4 && fileName.substring(fileName.length() - 4, fileName.length()).equals(".csv");
            }

            public String getDescription() {
                return "Comma-Separated Values (.csv)";
            }
        });
        if (fileChooser.showSaveDialog(this) == 0) {
            String fileName = fileChooser.getSelectedFile().getAbsolutePath();
            if (fileName.length() < 4 || !fileName.substring(fileName.length() - 4, fileName.length()).equals(".csv")) {
                fileName = fileName + ".csv";
            }
            try {
                String newline = System.getProperty("line.separator");
                FileWriter fileWriter = new FileWriter(new File(fileName));
                fileWriter.write("x;y" + newline);
                double[][] xyData = this.resultPlots.get(plotIndex).getXYData();
                for (int i = 0; i < xyData[0].length; ++i) {
                    fileWriter.write(String.valueOf(xyData[0][i]) + ";");
                    fileWriter.write(String.valueOf(xyData[1][i]) + newline);
                }
                fileWriter.close();
            }
            catch (IOException ioException) {
                JOptionPane.showMessageDialog(this, "The output file could not be written!", "File error", 0);
            }
        }
    }

    @Action
    public void exitApplication() {
        if (JOptionPane.showConfirmDialog(this, "Do you want to exit the application? Unsaved data will be lost!", "Exit", 0, 3) == 0) {
            this.dispose();
            System.exit(0);
        }
    }

    @Action
    public void showAboutBox() {
        HVLNoiseAboutBox aboutBox = new HVLNoiseAboutBox(this);
        aboutBox.setLocationRelativeTo(this);
        aboutBox.setVisible(true);
    }

    @Action
    public void showExplanationsBox() {
        HVLNoiseExplanationsBox explanationsBox = new HVLNoiseExplanationsBox(this);
        explanationsBox.setLocationRelativeTo(this);
        explanationsBox.setVisible(true);
    }

    private void initComponents() {
        this.calculationModeGroup = new ButtonGroup();
        this.mainPanel = new JPanel();
        this.systemsPanel = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.systemListModel = new DefaultListModel();
        this.systemList = new JList(this.systemListModel);
        this.addSystemButton = new JButton();
        this.modifySystemButton = new JButton();
        this.removeSystemButton = new JButton();
        this.audibleNoisePanel = new JPanel();
        this.calculateButton = new JButton();
        this.calculationMode1 = new JRadioButton();
        this.calculationMode2 = new JRadioButton();
        this.R5RainRate = new JTextField();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.R50RainRate = new JTextField();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.percentageOfRain = new JTextField();
        this.jLabel6 = new JLabel();
        this.rainRate = new JTextField();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.calculationAccuracy = new JComboBox();
        this.jLabel9 = new JLabel();
        this.hvlPanel = new JPanel();
        this.chartPanel = new ChartPanel(this.chart);
        this.plotPanel = new JPanel();
        this.addPlotButton = new JButton();
        this.removePlotButton = new JButton();
        this.showPlotButton = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.plotListModel = new DefaultListModel();
        this.plotList = new JList(this.plotListModel);
        this.menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu();
        this.newMenuItem = new JMenuItem();
        this.openMenuItem = new JMenuItem();
        this.saveMenuItem = new JMenuItem();
        this.exportMenu = new JMenu();
        this.jSeparator1 = new JSeparator();
        JMenuItem exitMenuItem = new JMenuItem();
        JMenu helpMenu = new JMenu();
        this.explanationsMenuItem = new JMenuItem();
        this.aboutMenuItem = new JMenuItem();
        this.setDefaultCloseOperation(0);
        ResourceMap resourceMap = Application.getInstance(HVLNoiseApp.class).getContext().getResourceMap(HVLNoiseView.class);
        this.setTitle(resourceMap.getString("HVLNoiseView.title", new Object[0]));
        this.setName("HVLNoiseView");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                HVLNoiseView.this.formWindowClosing(evt);
            }
        });
        this.mainPanel.setName("mainPanel");
        this.mainPanel.setRequestFocusEnabled(false);
        this.systemsPanel.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("systemsPanel.border.title", new Object[0])));
        this.systemsPanel.setName("systemsPanel");
        this.jScrollPane1.setName("jScrollPane1");
        this.systemList.setSelectionMode(0);
        this.systemList.setName("systemList");
        this.jScrollPane1.setViewportView(this.systemList);
        ApplicationActionMap actionMap = Application.getInstance(HVLNoiseApp.class).getContext().getActionMap(HVLNoiseView.class, this);
        this.addSystemButton.setAction(actionMap.get("addElectricalSystem"));
        this.addSystemButton.setText(resourceMap.getString("addSystemButton.text", new Object[0]));
        this.addSystemButton.setName("addSystemButton");
        this.modifySystemButton.setAction(actionMap.get("modifyElectricalSystem"));
        this.modifySystemButton.setText(resourceMap.getString("modifySystemButton.text", new Object[0]));
        this.modifySystemButton.setName("modifySystemButton");
        this.removeSystemButton.setAction(actionMap.get("removeElectricalSystem"));
        this.removeSystemButton.setText(resourceMap.getString("removeSystemButton.text", new Object[0]));
        this.removeSystemButton.setName("removeSystemButton");
        GroupLayout systemsPanelLayout = new GroupLayout(this.systemsPanel);
        this.systemsPanel.setLayout(systemsPanelLayout);
        systemsPanelLayout.setHorizontalGroup(systemsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, systemsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 261, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(systemsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.removeSystemButton, -1, -1, Short.MAX_VALUE).addComponent(this.modifySystemButton, -1, -1, Short.MAX_VALUE).addComponent(this.addSystemButton, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        systemsPanelLayout.setVerticalGroup(systemsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(systemsPanelLayout.createSequentialGroup().addGroup(systemsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(systemsPanelLayout.createSequentialGroup().addComponent(this.addSystemButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.modifySystemButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeSystemButton)).addComponent(this.jScrollPane1, -2, 80, -2)).addContainerGap(12, Short.MAX_VALUE)));
        this.audibleNoisePanel.setBorder(BorderFactory.createTitledBorder("Step 2: Calculate Audible Noise"));
        this.audibleNoisePanel.setName("audibleNoisePanel");
        this.calculateButton.setAction(actionMap.get("calculateAudibleNoise"));
        this.calculateButton.setText(resourceMap.getString("calculateButton.text", new Object[0]));
        this.calculateButton.setEnabled(false);
        this.calculateButton.setName("calculateButton");
        this.calculationModeGroup.add(this.calculationMode1);
        this.calculationMode1.setSelected(true);
        this.calculationMode1.setText(resourceMap.getString("calculationMode1.text", new Object[0]));
        this.calculationMode1.setName("calculationMode1");
        this.calculationMode1.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                HVLNoiseView.this.calculationMode1ItemStateChanged(evt);
            }
        });
        this.calculationModeGroup.add(this.calculationMode2);
        this.calculationMode2.setText(resourceMap.getString("calculationMode2.text", new Object[0]));
        this.calculationMode2.setName("calculationMode2");
        this.calculationMode2.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                HVLNoiseView.this.calculationMode2ItemStateChanged(evt);
            }
        });
        this.R5RainRate.setInputVerifier(new DecimalNumberVerifier(DecimalNumberVerifierType.DECIMAL_NUMBER_WITHIN_RANGE, this.verifierFlag, 1.0, 30.0));
        this.R5RainRate.setName("R5RainRate");
        this.jLabel1.setText(resourceMap.getString("jLabel1.text", new Object[0]));
        this.jLabel1.setName("jLabel1");
        this.jLabel2.setText(resourceMap.getString("jLabel2.text", new Object[0]));
        this.jLabel2.setName("jLabel2");
        this.jLabel3.setText(resourceMap.getString("jLabel3.text", new Object[0]));
        this.jLabel3.setName("jLabel3");
        this.R50RainRate.setInputVerifier(new DecimalNumberVerifier(DecimalNumberVerifierType.DECIMAL_NUMBER_WITHIN_RANGE, this.verifierFlag, 0.1, 30.0));
        this.R50RainRate.setName("R50RainRate");
        this.jLabel4.setText(resourceMap.getString("jLabel4.text", new Object[0]));
        this.jLabel4.setName("jLabel4");
        this.jLabel5.setText(resourceMap.getString("jLabel5.text", new Object[0]));
        this.jLabel5.setName("jLabel5");
        this.percentageOfRain.setInputVerifier(new DecimalNumberVerifier(DecimalNumberVerifierType.DECIMAL_NUMBER_WITHIN_RANGE, this.verifierFlag, 0.0, 100.0));
        this.percentageOfRain.setName("percentageOfRain");
        this.jLabel6.setText(resourceMap.getString("jLabel6.text", new Object[0]));
        this.jLabel6.setName("jLabel6");
        this.rainRate.setEnabled(false);
        this.rainRate.setInputVerifier(new DecimalNumberVerifier(DecimalNumberVerifierType.DECIMAL_NUMBER_WITHIN_RANGE, this.verifierFlag, 1.0, 30.0));
        this.rainRate.setName("rainRate");
        this.jLabel7.setText(resourceMap.getString("jLabel7.text", new Object[0]));
        this.jLabel7.setName("jLabel7");
        this.jLabel8.setText(resourceMap.getString("jLabel8.text", new Object[0]));
        this.jLabel8.setName("jLabel8");
        this.calculationAccuracy.setModel(new DefaultComboBoxModel<String>(new String[]{"lowest", "low", "medium", "high", "highest"}));
        this.calculationAccuracy.setSelectedIndex(2);
        this.calculationAccuracy.setName("calculationAccuracy");
        this.jLabel9.setText(resourceMap.getString("jLabel9.text", new Object[0]));
        this.jLabel9.setName("jLabel9");
        GroupLayout audibleNoisePanelLayout = new GroupLayout(this.audibleNoisePanel);
        this.audibleNoisePanel.setLayout(audibleNoisePanelLayout);
        audibleNoisePanelLayout.setHorizontalGroup(audibleNoisePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(audibleNoisePanelLayout.createSequentialGroup().addGroup(audibleNoisePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(audibleNoisePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.calculationMode1)).addGroup(audibleNoisePanelLayout.createSequentialGroup().addGap(27, 27, 27).addGroup(audibleNoisePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(audibleNoisePanelLayout.createSequentialGroup().addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.percentageOfRain, -2, 40, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel6)).addGroup(audibleNoisePanelLayout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.R5RainRate, -2, 40, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addGap(31, 31, 31).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.R50RainRate, -2, 40, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4)))).addGroup(audibleNoisePanelLayout.createSequentialGroup().addGap(27, 27, 27).addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rainRate, -2, 40, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel8)).addGroup(audibleNoisePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.calculationMode2)).addGroup(audibleNoisePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel9).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.calculationAccuracy, -2, -1, -2).addGap(18, 18, 18).addComponent(this.calculateButton))).addContainerGap(16, Short.MAX_VALUE)));
        audibleNoisePanelLayout.setVerticalGroup(audibleNoisePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, audibleNoisePanelLayout.createSequentialGroup().addComponent(this.calculationMode1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(audibleNoisePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.R5RainRate, -2, -1, -2).addComponent(this.jLabel2).addComponent(this.jLabel3).addComponent(this.R50RainRate, -2, -1, -2).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(audibleNoisePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.jLabel6).addComponent(this.percentageOfRain, -2, -1, -2)).addGap(7, 7, 7).addComponent(this.calculationMode2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(audibleNoisePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.rainRate, -2, -1, -2).addComponent(this.jLabel8)).addGap(18, 18, 18).addGroup(audibleNoisePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel9).addComponent(this.calculationAccuracy, -2, -1, -2).addComponent(this.calculateButton)).addGap(51, 51, 51)));
        this.hvlPanel.setBorder(BorderFactory.createTitledBorder("High Voltage Line"));
        this.hvlPanel.setName("hvlPanel");
        this.chartPanel.setBackground(resourceMap.getColor("chartPanel.background"));
        this.chartPanel.setName("chartPanel");
        this.chartPanel.setPreferredSize(new Dimension(420, 420));
        GroupLayout chartPanelLayout = new GroupLayout(this.chartPanel);
        this.chartPanel.setLayout(chartPanelLayout);
        chartPanelLayout.setHorizontalGroup(chartPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 420, Short.MAX_VALUE));
        chartPanelLayout.setVerticalGroup(chartPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 420, Short.MAX_VALUE));
        GroupLayout hvlPanelLayout = new GroupLayout(this.hvlPanel);
        this.hvlPanel.setLayout(hvlPanelLayout);
        hvlPanelLayout.setHorizontalGroup(hvlPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(hvlPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.chartPanel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        hvlPanelLayout.setVerticalGroup(hvlPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(hvlPanelLayout.createSequentialGroup().addComponent(this.chartPanel, -2, -1, -2).addContainerGap(13, Short.MAX_VALUE)));
        this.plotPanel.setBorder(BorderFactory.createTitledBorder("Step 3: Plot Results"));
        this.plotPanel.setName("plotPanel");
        this.addPlotButton.setAction(actionMap.get("addResultPlot"));
        this.addPlotButton.setText(resourceMap.getString("addPlotButton.text", new Object[0]));
        this.addPlotButton.setEnabled(false);
        this.addPlotButton.setName("addPlotButton");
        this.removePlotButton.setAction(actionMap.get("removeResultPlot"));
        this.removePlotButton.setText(resourceMap.getString("removePlotButton.text", new Object[0]));
        this.removePlotButton.setEnabled(false);
        this.removePlotButton.setName("removePlotButton");
        this.showPlotButton.setAction(actionMap.get("showResultPlot"));
        this.showPlotButton.setText(resourceMap.getString("showPlotButton.text", new Object[0]));
        this.showPlotButton.setEnabled(false);
        this.showPlotButton.setName("showPlotButton");
        this.jScrollPane2.setName("jScrollPane2");
        this.plotList.setSelectionMode(0);
        this.plotList.setName("plotList");
        this.jScrollPane2.setViewportView(this.plotList);
        GroupLayout plotPanelLayout = new GroupLayout(this.plotPanel);
        this.plotPanel.setLayout(plotPanelLayout);
        plotPanelLayout.setHorizontalGroup(plotPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, plotPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane2, -1, 261, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(plotPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.addPlotButton, -1, -1, Short.MAX_VALUE).addComponent(this.showPlotButton, -1, -1, Short.MAX_VALUE).addComponent(this.removePlotButton)).addContainerGap()));
        plotPanelLayout.setVerticalGroup(plotPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(plotPanelLayout.createSequentialGroup().addComponent(this.addPlotButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removePlotButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.showPlotButton).addGap(12, 12, 12)).addGroup(plotPanelLayout.createSequentialGroup().addComponent(this.jScrollPane2, 0, 0, Short.MAX_VALUE).addContainerGap()));
        GroupLayout mainPanelLayout = new GroupLayout(this.mainPanel);
        this.mainPanel.setLayout(mainPanelLayout);
        mainPanelLayout.setHorizontalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.hvlPanel, -2, 450, -2).addGap(10, 10, 10).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.plotPanel, -1, -1, Short.MAX_VALUE).addComponent(this.audibleNoisePanel, -1, -1, Short.MAX_VALUE).addComponent(this.systemsPanel, -1, -1, Short.MAX_VALUE))));
        mainPanelLayout.setVerticalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addGap(10, 10, 10).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.hvlPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, mainPanelLayout.createSequentialGroup().addComponent(this.systemsPanel, -2, -1, -2).addGap(10, 10, 10).addComponent(this.audibleNoisePanel, -2, 200, -2).addGap(10, 10, 10).addComponent(this.plotPanel, -2, -1, -2))).addGap(15, 15, 15)));
        this.menuBar.setName("menuBar");
        fileMenu.setAction(actionMap.get("exitApplication"));
        fileMenu.setText(resourceMap.getString("fileMenu.text", new Object[0]));
        fileMenu.setName("fileMenu");
        this.newMenuItem.setAction(actionMap.get("newFile"));
        this.newMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.newMenuItem.setText(resourceMap.getString("newMenuItem.text", new Object[0]));
        this.newMenuItem.setToolTipText(resourceMap.getString("newMenuItem.toolTipText", new Object[0]));
        this.newMenuItem.setName("newMenuItem");
        fileMenu.add(this.newMenuItem);
        this.openMenuItem.setAction(actionMap.get("openFile"));
        this.openMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.openMenuItem.setText(resourceMap.getString("openMenuItem.text", new Object[0]));
        this.openMenuItem.setToolTipText(resourceMap.getString("openMenuItem.toolTipText", new Object[0]));
        this.openMenuItem.setName("openMenuItem");
        fileMenu.add(this.openMenuItem);
        this.saveMenuItem.setAction(actionMap.get("saveFile"));
        this.saveMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.saveMenuItem.setText(resourceMap.getString("saveMenuItem.text", new Object[0]));
        this.saveMenuItem.setToolTipText(resourceMap.getString("saveMenuItem.toolTipText", new Object[0]));
        this.saveMenuItem.setName("saveMenuItem");
        fileMenu.add(this.saveMenuItem);
        this.exportMenu.setText(resourceMap.getString("exportMenu.text", new Object[0]));
        this.exportMenu.setToolTipText(resourceMap.getString("exportMenu.toolTipText", new Object[0]));
        this.exportMenu.setEnabled(false);
        this.exportMenu.setName("exportMenu");
        fileMenu.add(this.exportMenu);
        this.jSeparator1.setName("jSeparator1");
        fileMenu.add(this.jSeparator1);
        exitMenuItem.setAction(actionMap.get("exitApplication"));
        exitMenuItem.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        exitMenuItem.setText(resourceMap.getString("exitMenuItem.text", new Object[0]));
        exitMenuItem.setToolTipText(resourceMap.getString("exitMenuItem.toolTipText", new Object[0]));
        exitMenuItem.setName("exitMenuItem");
        fileMenu.add(exitMenuItem);
        this.menuBar.add(fileMenu);
        helpMenu.setText(resourceMap.getString("helpMenu.text", new Object[0]));
        helpMenu.setName("helpMenu");
        this.explanationsMenuItem.setAction(actionMap.get("showExplanationsBox"));
        this.explanationsMenuItem.setText(resourceMap.getString("explanationsMenuItem.text", new Object[0]));
        this.explanationsMenuItem.setToolTipText(resourceMap.getString("explanationsMenuItem.toolTipText", new Object[0]));
        this.explanationsMenuItem.setName("explanationsMenuItem");
        helpMenu.add(this.explanationsMenuItem);
        this.aboutMenuItem.setAction(actionMap.get("showAboutBox"));
        this.aboutMenuItem.setToolTipText(resourceMap.getString("aboutMenuItem.toolTipText", new Object[0]));
        this.aboutMenuItem.setName("aboutMenuItem");
        helpMenu.add(this.aboutMenuItem);
        this.menuBar.add(helpMenu);
        this.setJMenuBar(this.menuBar);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mainPanel, -2, 856, -2));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mainPanel, -2, 482, -2));
        this.pack();
    }

    private void calculationMode1ItemStateChanged(ItemEvent evt) {
        this.onCalculationModeChange();
    }

    private void calculationMode2ItemStateChanged(ItemEvent evt) {
        this.onCalculationModeChange();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.exitApplication();
    }
}

