/*
 * Decompiled with CFR 0.152.
 */
package hvlnoise;

import Jama.Matrix;
import hvlnoise.AudibleNoise;
import hvlnoise.ElectricField;
import hvlnoise.ResultPlotType;
import hvlnoise.SoundLevelType;
import java.awt.Color;
import java.awt.Paint;
import java.io.Serializable;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartFrame;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.DefaultXYDataset;
import org.jfree.data.xy.XYDataset;

public class ResultPlot
implements Serializable {
    private ChartFrame chartFrame;
    private ResultPlotType plotType;
    private int systemIndex;
    private int conductorIndex;
    private int subconductorIndex;
    private SoundLevelType levelType;
    private double yPosition;
    private double xPositionMin;
    private double xPositionMax;
    private double[][] xyData;

    public void createElectricFieldPlot(ElectricField electricField, int systemIndex, int conductorIndex, int subconductorIndex) {
        this.plotType = ResultPlotType.ELECTRIC_FIELD_PLOT;
        this.systemIndex = systemIndex;
        this.conductorIndex = conductorIndex;
        this.subconductorIndex = subconductorIndex;
        double[] fieldValues = electricField.getRmsFieldOfSubconductor(systemIndex, conductorIndex, subconductorIndex);
        int numberOfFieldValues = fieldValues.length;
        this.xyData = new double[2][numberOfFieldValues];
        for (int i = 0; i < numberOfFieldValues; ++i) {
            this.xyData[0][i] = Math.PI * 2 / (double)numberOfFieldValues * (double)i;
            this.xyData[1][i] = fieldValues[i];
        }
        String conductorStr = "(ES" + String.valueOf(systemIndex + 1) + ", Ph" + String.valueOf(conductorIndex + 1) + ", SC" + String.valueOf(subconductorIndex + 1) + ")";
        this.createResultPlot("HVLNoise - Electric Field " + conductorStr, "Electric Field " + conductorStr, "Angle [rad]", "Electric Field [kV(rms)/cm]", this.xyData);
    }

    public void createAudibleNoisePlot(AudibleNoise audibleNoise, SoundLevelType levelType, double yPosition, double xPositionMin, double xPositionMax) {
        this.plotType = ResultPlotType.AUDIBLE_NOISE_PLOT;
        this.levelType = levelType;
        this.yPosition = yPosition;
        this.xPositionMin = xPositionMin;
        this.xPositionMax = xPositionMax;
        double resolution = 0.1;
        int numberOfSoundLevelValues = (int)Math.floor((xPositionMax - xPositionMin) / resolution);
        this.xyData = new double[2][numberOfSoundLevelValues];
        String noiseStr = "";
        block6: for (int i = 0; i < numberOfSoundLevelValues; ++i) {
            this.xyData[0][i] = xPositionMin + (double)i * resolution;
            double[][] locationVector = new double[][]{{this.xyData[0][i]}, {yPosition}};
            switch (levelType) {
                case L5_LEVEL: {
                    this.xyData[1][i] = audibleNoise.getSoundLevelL5AtLocation(new Matrix((double[][])locationVector));
                    if (i != numberOfSoundLevelValues - 1) continue block6;
                    noiseStr = "(L5 Level)";
                    continue block6;
                }
                case L50_LEVEL: {
                    this.xyData[1][i] = audibleNoise.getSoundLevelL50AtLocation(new Matrix((double[][])locationVector));
                    if (i != numberOfSoundLevelValues - 1) continue block6;
                    noiseStr = "(L50 Level)";
                    continue block6;
                }
                case Leq_LEVEL_DURING_RAIN: {
                    this.xyData[1][i] = audibleNoise.getSoundLevelLeqDuringRainAtLocation(new Matrix((double[][])locationVector));
                    if (i != numberOfSoundLevelValues - 1) continue block6;
                    noiseStr = "(Leq Level during Rain)";
                    continue block6;
                }
                case Leq_LEVEL_DURING_PERIOD: {
                    this.xyData[1][i] = audibleNoise.getSoundLevelLeqDuringPeriodAtLocation(new Matrix((double[][])locationVector));
                    if (i != numberOfSoundLevelValues - 1) continue block6;
                    noiseStr = "(Leq Level during Period)";
                }
            }
        }
        this.createResultPlot("HVLNoise - Audible Noise " + noiseStr, "Audible Noise " + noiseStr, "x [m]", "Sound Level [dB(A)]", this.xyData);
    }

    public ChartFrame getChartFrame() {
        return this.chartFrame;
    }

    public ResultPlotType getResultPlotType() {
        return this.plotType;
    }

    public int getSystemIndex() {
        return this.systemIndex;
    }

    public int getConductorIndex() {
        return this.conductorIndex;
    }

    public int getSubconductorIndex() {
        return this.subconductorIndex;
    }

    public SoundLevelType getSoundPressureLevelType() {
        return this.levelType;
    }

    public double getYPosition() {
        return this.yPosition;
    }

    public double getXPositionMin() {
        return this.xPositionMin;
    }

    public double getXPositionMax() {
        return this.xPositionMax;
    }

    public double[][] getXYData() {
        return this.xyData;
    }

    private void createResultPlot(String frameTitle, String chartTitle, String xLabel, String yLabel, double[][] xyData) {
        DefaultXYDataset xyDataset = new DefaultXYDataset();
        xyDataset.addSeries((Comparable)Integer.valueOf(0), xyData);
        JFreeChart chart = ChartFactory.createXYLineChart((String)chartTitle, (String)xLabel, (String)yLabel, (XYDataset)xyDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
        this.chartFrame = new ChartFrame(frameTitle, chart);
        this.chartFrame.setSize(600, 400);
        XYPlot plot = chart.getXYPlot();
        plot.setBackgroundPaint((Paint)Color.white);
        plot.setDomainGridlinePaint((Paint)Color.black);
        plot.setRangeGridlinePaint((Paint)Color.black);
        plot.setOutlinePaint((Paint)Color.black);
        XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
        renderer.setSeriesShapesVisible(0, false);
        renderer.setSeriesPaint(0, (Paint)Color.blue);
        plot.setRenderer((XYItemRenderer)renderer);
        double yMax = this.xyData[1][0];
        double yMin = this.xyData[1][0];
        for (int i = 0; i < this.xyData[0].length; ++i) {
            if (this.xyData[1][i] > yMax) {
                yMax = this.xyData[1][i];
            }
            if (!(this.xyData[1][i] < yMin)) continue;
            yMin = this.xyData[1][i];
        }
        plot.getRangeAxis().setLowerBound(yMin * 0.95);
        plot.getRangeAxis().setUpperBound(yMax * 1.05);
    }
}

