
#ifndef nmbgfioc_included
    #include "nmbgfioc.h"
#endif




#ifndef NMBGF_DisableExceptions
    #define ExceptionTest
#else
    #define ExceptionTest \
        if (NMBGF_WasError (hOC)) \
            throw NMBGF_OutputTranslatorException ();
#endif




//------------------------------------------------------------------------------
//
//    class NMBGF_OutputTranslator
//
//------------------------------------------------------------------------------




NMBGF_OutputTranslator::NMBGF_OutputTranslator
    (const char* FileName, unsigned long Options)
{
    hOC = NMBGF_CreateOutputContextAttachedToFile2 (FileName, Options);

    #ifndef NMBGF_DisableExceptions
        if (!hOC)
            throw NMBGF_OutputTranslatorException ();
    #endif
};




NMBGF_OutputTranslator::NMBGF_OutputTranslator
    (void*                  FileHandle,
     NMBGF_FileCloseFunType FileCloseFun,
     NMBGF_FileWriteFunType FileWriteFun,
     unsigned long          Options)
{
    hOC = NMBGF_CreateOutputContext2
        (FileHandle, FileCloseFun, FileWriteFun, Options);

    #ifndef NMBGF_DisableExceptions
        if (!hOC)
            throw NMBGF_OutputTranslatorException ();
    #endif
};




NMBGF_OutputTranslator::~NMBGF_OutputTranslator ()
{
    NMBGF_EndWritingOutputFile (hOC);
};








//  Map each NMBGF_OutputTranslator member function to its corresponding
//  C function.

int NMBGF_OutputTranslator::IsInASCIIMode ()
{
    return NMBGF_IsInASCIIMode (hOC);
};


int NMBGF_OutputTranslator::WasError ()
{
    return NMBGF_WasError (hOC);
};


void NMBGF_OutputTranslator::ResetErrorFlag ()
{
    NMBGF_ResetErrorFlag (hOC);
};


void NMBGF_OutputTranslator::PushOutputStreamBuffer ()
{
    NMBGF_PushOutputStreamBuffer (hOC);

    ExceptionTest;
};


NMBGF_INTEGER NMBGF_OutputTranslator::GetTopOutputStreamBufferLengthInBytes ()
{
    NMBGF_INTEGER L = NMBGF_GetTopOutputStreamBufferLengthInBytes (hOC);

    ExceptionTest;

    return L;
};


void NMBGF_OutputTranslator::SetTopClientStackCounter (NMBGF_INTEGER X)
{
    NMBGF_SetTopClientStackCounter (hOC, X);

    ExceptionTest;
};


void NMBGF_OutputTranslator::IncrementTopClientStackCounter ()
{
    NMBGF_IncrementTopClientStackCounter (hOC);

    ExceptionTest;
};


NMBGF_INTEGER NMBGF_OutputTranslator::GetTopClientStackCounter ()
{
    NMBGF_INTEGER C = NMBGF_GetTopClientStackCounter (hOC);

    ExceptionTest;

    return C;
};


void NMBGF_OutputTranslator::PutToTopOutputStreamBuffer
    (void* DataBlock, NMBGF_INTEGER DataBlockLength)
{
    NMBGF_PutToTopOutputStreamBuffer (hOC, DataBlock, DataBlockLength);

    ExceptionTest;
};


void NMBGF_OutputTranslator::WriteIntegerToPreceedingBuffer
    (NMBGF_INTEGER Count)
{
    NMBGF_WriteIntegerToPreceedingBuffer (hOC, Count);

    ExceptionTest;
};


void NMBGF_OutputTranslator::PopOutputStreamBuffer ()
{
    NMBGF_PopOutputStreamBuffer (hOC);

    ExceptionTest;
};


void NMBGF_OutputTranslator::AutoClosePreviousSection ()
{
    NMBGF_AutoClosePreviousSection (hOC);

    ExceptionTest;
};


void NMBGF_OutputTranslator::BeginOptionalSubsections ()
{
    NMBGF_BeginOptionalSubsections (hOC);

    ExceptionTest;
};


void NMBGF_OutputTranslator::EndOptionalSubsections ()
{
    NMBGF_EndOptionalSubsections (hOC);

    ExceptionTest;
};


void NMBGF_OutputTranslator::PutStandardSectionProlog (NMBGF_LITERAL SectionName)
{
    NMBGF_PutStandardSectionProlog (hOC, SectionName);

    ExceptionTest;
};


void NMBGF_OutputTranslator::PutLiteral (NMBGF_LITERAL X)
{
    NMBGF_PutLiteral (hOC, X);

    ExceptionTest;
};


void NMBGF_OutputTranslator::PutString (NMBGF_STRING X)
{
    NMBGF_PutString (hOC, X);

    ExceptionTest;
};


void NMBGF_OutputTranslator::PutInteger (NMBGF_INTEGER X)
{
    NMBGF_PutInteger (hOC, X);

    ExceptionTest;
};


void NMBGF_OutputTranslator::PutFloat (NMBGF_FLOAT X)
{
    NMBGF_PutFloat (hOC, X);

    ExceptionTest;
};


void NMBGF_OutputTranslator::PutCoordinate (NMBGF_COORDINATE X)
{
    NMBGF_PutCoordinate (hOC, X);

    ExceptionTest;
};




void NMBGF_OutputTranslator::PutAREMSection (NMBGF_STRING CATAGORY)
{
    NMBGF_PutAREMSection (hOC, CATAGORY);

    ExceptionTest;
};

void NMBGF_OutputTranslator::AREM_BeginPoints ()
{
    NMBGF_AREM_BeginPoints (hOC);

    ExceptionTest;
};

void NMBGF_OutputTranslator::AREM_PutPoint (NMBGF_COORDINATE P)
{
    NMBGF_AREM_PutPoint (hOC, P);

    ExceptionTest;
};

void NMBGF_OutputTranslator::AREM_PointsDone ()
{
    NMBGF_AREM_PointsDone (hOC);

    ExceptionTest;
};

void NMBGF_OutputTranslator::AREM_ClosedPolygonsDone ()
{
    NMBGF_AREM_ClosedPolygonsDone (hOC);

    ExceptionTest;
};

void NMBGF_OutputTranslator::PutARESSection (NMBGF_STRING CATAGORY)
{
    NMBGF_PutARESSection (hOC, CATAGORY);

    ExceptionTest;
};

void NMBGF_OutputTranslator::ARES_PutPoint (NMBGF_COORDINATE P)
{
    NMBGF_ARES_PutPoint (hOC, P);

    ExceptionTest;
};

void NMBGF_OutputTranslator::ARES_PointsDone ()
{
    NMBGF_ARES_PointsDone (hOC);

    ExceptionTest;
};

void NMBGF_OutputTranslator::PutATRCSection
    (NMBGF_STRING NAME, NMBGF_COORDINATE VALUE)
{
    NMBGF_PutATRCSection (hOC, NAME, VALUE);

    ExceptionTest;
};

void NMBGF_OutputTranslator::PutATRFSection
    (NMBGF_STRING NAME, NMBGF_FLOAT VALUE)
{
    NMBGF_PutATRFSection (hOC, NAME, VALUE);

    ExceptionTest;
};

void NMBGF_OutputTranslator::PutATRISection
    (NMBGF_STRING NAME, NMBGF_INTEGER VALUE)
{
    NMBGF_PutATRISection (hOC, NAME, VALUE);

    ExceptionTest;
};

void NMBGF_OutputTranslator::PutATRSSection
    (NMBGF_STRING NAME, NMBGF_STRING VALUE)
{
    NMBGF_PutATRSSection (hOC, NAME, VALUE);

    ExceptionTest;
};

void NMBGF_OutputTranslator::PutATRTSection (NMBGF_STRING NAME)
{
    NMBGF_PutATRTSection (hOC, NAME);

    ExceptionTest;
};

void NMBGF_OutputTranslator::ATRT_AddColumn
    (NMBGF_STRING COLNAME, NMBGF_ATRT_COLTYPE_ENUM COLTYPE)
{
    NMBGF_ATRT_AddColumn (hOC, COLNAME, COLTYPE);

    ExceptionTest;
};

void NMBGF_OutputTranslator::ATRT_ColumnsDone ()
{
    NMBGF_ATRT_ColumnsDone (hOC);

    ExceptionTest;
};

void NMBGF_OutputTranslator::ATRT_PutString (NMBGF_STRING X)
{
    NMBGF_ATRT_PutString (hOC, X);

    ExceptionTest;
};

void NMBGF_OutputTranslator::ATRT_PutInteger (NMBGF_INTEGER X)
{
    NMBGF_ATRT_PutInteger (hOC, X);

    ExceptionTest;
};

void NMBGF_OutputTranslator::ATRT_PutFloat (NMBGF_FLOAT X)
{
    NMBGF_ATRT_PutFloat (hOC, X);

    ExceptionTest;
};

void NMBGF_OutputTranslator::ATRT_PutCoordinate (NMBGF_COORDINATE X)
{
    NMBGF_ATRT_PutCoordinate (hOC, X);

    ExceptionTest;
};

void NMBGF_OutputTranslator::ATRT_RowDone ()
{
    NMBGF_ATRT_RowDone (hOC);

    ExceptionTest;
};

void NMBGF_OutputTranslator::ATRT_TableDone ()
{
    NMBGF_ATRT_TableDone (hOC);

    ExceptionTest;
};

void NMBGF_OutputTranslator::PutBKMPSection
    (NMBGF_STRING FILENAME, NMBGF_STRING CATEGORY)
{
    NMBGF_PutBKMPSection (hOC, FILENAME, CATEGORY);

    ExceptionTest;
};

void NMBGF_OutputTranslator::PutCARTSection
    (NMBGF_FLOAT LOR,
     NMBGF_FLOAT LAR,
     NMBGF_FLOAT XR,
     NMBGF_FLOAT YR,
     NMBGF_CART_UNIT_ENUM UNIT,
     NMBGF_FLOAT ROT)
{
    NMBGF_PutCARTSection (hOC, LOR, LAR, XR, YR, UNIT, ROT);

    ExceptionTest;
};

void NMBGF_OutputTranslator::PutDAPYSection ()
{
    NMBGF_PutDAPYSection (hOC);

    ExceptionTest;
};

void NMBGF_OutputTranslator::DAPY_BeginPoints ()
{
    NMBGF_DAPY_BeginPoints (hOC);

    ExceptionTest;
};

void NMBGF_OutputTranslator::DAPY_PutPoint (NMBGF_COORDINATE P)
{
    NMBGF_DAPY_PutPoint (hOC, P);

    ExceptionTest;
};

void NMBGF_OutputTranslator::DAPY_PointsDone ()
{
    NMBGF_DAPY_PointsDone (hOC);

    ExceptionTest;
};

void NMBGF_OutputTranslator::DAPY_ClosedPolygonsDone ()
{
    NMBGF_DAPY_ClosedPolygonsDone (hOC);

    ExceptionTest;
};

void NMBGF_OutputTranslator::PutDATESection
    (NMBGF_INTEGER DAY, NMBGF_INTEGER MONTH, NMBGF_INTEGER YEAR)
{
    NMBGF_PutDATESection (hOC, DAY, MONTH, YEAR);

    ExceptionTest;
};

void NMBGF_OutputTranslator::PutDESLSection (NMBGF_STRING D)
{
    NMBGF_PutDESLSection (hOC, D);

    ExceptionTest;
};

void NMBGF_OutputTranslator::PutDESSSection (NMBGF_STRING D)
{
    NMBGF_PutDESSSection (hOC, D);

    ExceptionTest;
};

void NMBGF_OutputTranslator::PutDPALSection ()
{
    NMBGF_PutDPALSection (hOC);

    ExceptionTest;
};

void NMBGF_OutputTranslator::DPAL_PutDataPoint (NMBGF_COORDINATE P, NMBGF_FLOAT V)
{
    NMBGF_DPAL_PutDataPoint (hOC, P, V);

    ExceptionTest;
};

void NMBGF_OutputTranslator::DPAL_DataPointsDone ()
{
    NMBGF_DPAL_DataPointsDone (hOC);

    ExceptionTest;
};

void NMBGF_OutputTranslator::PutGRIDSection
    (NMBGF_STRING NAME,
     NMBGF_INTEGER NI,
     NMBGF_INTEGER NJ,
     NMBGF_FLOAT DI,
     NMBGF_FLOAT DJ,
     NMBGF_GRID_UNIT_ENUM UNIT,
     NMBGF_COORDINATE ORIGIN,
     NMBGF_FLOAT ROT)
{
    NMBGF_PutGRIDSection (hOC, NAME, NI, NJ, DI, DJ, UNIT, ORIGIN, ROT);

    ExceptionTest;
};

void NMBGF_OutputTranslator::GRID_PutGridPoint (NMBGF_FLOAT V)
{
    NMBGF_GRID_PutGridPoint (hOC, V);

    ExceptionTest;
};

void NMBGF_OutputTranslator::PutGTSHSection (NMBGF_FLOAT VMIN, NMBGF_FLOAT VMAX)
{
    NMBGF_PutGTSHSection (hOC, VMIN, VMAX);

    ExceptionTest;
};

void NMBGF_OutputTranslator::PutHEADSection (NMBGF_FLOAT H)
{
    NMBGF_PutHEADSection (hOC, H);

    ExceptionTest;
};

void NMBGF_OutputTranslator::PutLINCSection
    (NMBGF_STRING         CATAGORY,
     NMBGF_LINC_UNIT_ENUM UNIT,
     NMBGF_COORDINATE     P0,
     NMBGF_FLOAT          H0)
{
    NMBGF_PutLINCSection (hOC, CATAGORY, UNIT, P0, H0);

    ExceptionTest;
};

void NMBGF_OutputTranslator::LINC_PutDSTRCommand (NMBGF_FLOAT DIST)
{
    NMBGF_LINC_PutDSTRCommand (hOC, DIST);

    ExceptionTest;
};

void NMBGF_OutputTranslator::LINC_PutDARRCommand
    (NMBGF_FLOAT ANGLE, NMBGF_FLOAT RADIUS)
{
    NMBGF_LINC_PutDARRCommand (hOC, ANGLE, RADIUS);

    ExceptionTest;
};

void NMBGF_OutputTranslator::LINC_PutDALACommand
    (NMBGF_FLOAT HEAD, NMBGF_FLOAT RADIUS)
{
    NMBGF_LINC_PutDALACommand (hOC, HEAD, RADIUS);

    ExceptionTest;
};

void NMBGF_OutputTranslator::LINC_PutDARACommand
    (NMBGF_FLOAT HEAD, NMBGF_FLOAT RADIUS)
{
    NMBGF_LINC_PutDARACommand (hOC, HEAD, RADIUS);

    ExceptionTest;
};

void NMBGF_OutputTranslator::LINC_PutDAPTCommand (NMBGF_COORDINATE P)
{
    NMBGF_LINC_PutDAPTCommand (hOC, P);

    ExceptionTest;
};

void NMBGF_OutputTranslator::LINC_PutDAPHCommand
    (NMBGF_COORDINATE P, NMBGF_FLOAT HEAD)
{
    NMBGF_LINC_PutDAPHCommand (hOC, P, HEAD);

    ExceptionTest;
};

void NMBGF_OutputTranslator::LINC_PutMSTRCommand (NMBGF_FLOAT DIST)
{
    NMBGF_LINC_PutMSTRCommand (hOC, DIST);

    ExceptionTest;
};

void NMBGF_OutputTranslator::LINC_PutMARRCommand
    (NMBGF_FLOAT ANGLE, NMBGF_FLOAT RADIUS)
{
    NMBGF_LINC_PutMARRCommand (hOC, ANGLE, RADIUS);

    ExceptionTest;
};

void NMBGF_OutputTranslator::LINC_PutMALACommand
    (NMBGF_FLOAT HEAD, NMBGF_FLOAT RADIUS)
{
    NMBGF_LINC_PutMALACommand (hOC, HEAD, RADIUS);

    ExceptionTest;
};

void NMBGF_OutputTranslator::LINC_PutMARACommand
    (NMBGF_FLOAT HEAD, NMBGF_FLOAT RADIUS)
{
    NMBGF_LINC_PutMARACommand (hOC, HEAD, RADIUS);

    ExceptionTest;
};

void NMBGF_OutputTranslator::LINC_PutMAPTCommand (NMBGF_COORDINATE P)
{
    NMBGF_LINC_PutMAPTCommand (hOC, P);

    ExceptionTest;
};

void NMBGF_OutputTranslator::LINC_PutMAPHCommand
    (NMBGF_COORDINATE P, NMBGF_FLOAT HEAD)
{
    NMBGF_LINC_PutMAPHCommand (hOC, P, HEAD);

    ExceptionTest;
};

void NMBGF_OutputTranslator::LINC_PutTNRLCommand (NMBGF_FLOAT ANGLE)
{
    NMBGF_LINC_PutTNRLCommand (hOC, ANGLE);

    ExceptionTest;
};

void NMBGF_OutputTranslator::LINC_PutTNAHCommand (NMBGF_FLOAT HEAD)
{
    NMBGF_LINC_PutTNAHCommand (hOC, HEAD);

    ExceptionTest;
};

void NMBGF_OutputTranslator::LINC_PutTRFPCommand (NMBGF_COORDINATE P)
{
    NMBGF_LINC_PutTRFPCommand (hOC, P);

    ExceptionTest;
};

void NMBGF_OutputTranslator::LINC_PutTL90Command ()
{
    NMBGF_LINC_PutTL90Command (hOC);

    ExceptionTest;
};

void NMBGF_OutputTranslator::LINC_PutTR90Command ()
{
    NMBGF_LINC_PutTR90Command (hOC);

    ExceptionTest;
};

void NMBGF_OutputTranslator::LINC_PutT180Command ()
{
    NMBGF_LINC_PutT180Command (hOC);

    ExceptionTest;
};

void NMBGF_OutputTranslator::LINC_CommandsDone ()
{
    NMBGF_LINC_CommandsDone (hOC);

    ExceptionTest;
};

void NMBGF_OutputTranslator::PutLINMSection (NMBGF_STRING CATAGORY)
{
    NMBGF_PutLINMSection (hOC, CATAGORY);

    ExceptionTest;
};

void NMBGF_OutputTranslator::LINM_BeginPoints ()
{
    NMBGF_LINM_BeginPoints (hOC);

    ExceptionTest;
};

void NMBGF_OutputTranslator::LINM_PutPoint (NMBGF_COORDINATE P)
{
    NMBGF_LINM_PutPoint (hOC, P);

    ExceptionTest;
};

void NMBGF_OutputTranslator::LINM_PointsDone ()
{
    NMBGF_LINM_PointsDone (hOC);

    ExceptionTest;
};

void NMBGF_OutputTranslator::LINM_ContinuousLinesDone ()
{
    NMBGF_LINM_ContinuousLinesDone (hOC);

    ExceptionTest;
};

void NMBGF_OutputTranslator::PutLINSSection (NMBGF_STRING CATAGORY)
{
    NMBGF_PutLINSSection (hOC, CATAGORY);

    ExceptionTest;
};

void NMBGF_OutputTranslator::LINS_PutPoint (NMBGF_COORDINATE P)
{
    NMBGF_LINS_PutPoint (hOC, P);

    ExceptionTest;
};

void NMBGF_OutputTranslator::LINS_PointsDone ()
{
    NMBGF_LINS_PointsDone (hOC);

    ExceptionTest;
};

void NMBGF_OutputTranslator::PutMTRCSection
    (NMBGF_STRING TYPE, NMBGF_STRING UNIT)
{
    NMBGF_PutMTRCSection (hOC, TYPE, UNIT);

    ExceptionTest;
};

void NMBGF_OutputTranslator::PutPERSSection
    (NMBGF_STRING NAME,
     NMBGF_STRING TITLE,
     NMBGF_STRING COMPANY,
     NMBGF_STRING ADDRESS,
     NMBGF_STRING PHONE,
     NMBGF_STRING FAX,
     NMBGF_STRING EMAIL)
{
    NMBGF_PutPERSSection
        (hOC, NAME, TITLE, COMPANY, ADDRESS, PHONE, FAX, EMAIL);

    ExceptionTest;
};

void NMBGF_OutputTranslator::PutPNTMSection (NMBGF_STRING CATAGORY)
{
    NMBGF_PutPNTMSection (hOC, CATAGORY);

    ExceptionTest;
};

void NMBGF_OutputTranslator::PNTM_PutPoint (NMBGF_COORDINATE P)
{
    NMBGF_PNTM_PutPoint (hOC, P);

    ExceptionTest;
};

void NMBGF_OutputTranslator::PNTM_PointsDone ()
{
    NMBGF_PNTM_PointsDone (hOC);

    ExceptionTest;
};

void NMBGF_OutputTranslator::PutPNTSSection
    (NMBGF_STRING CATAGORY, NMBGF_COORDINATE P)
{
    NMBGF_PutPNTSSection (hOC, CATAGORY, P);

    ExceptionTest;
};

void NMBGF_OutputTranslator::PutPROGSection
    (NMBGF_STRING USERNAME, NMBGF_STRING FILENAME, NMBGF_FLOAT VERSION)
{
    NMBGF_PutPROGSection (hOC, USERNAME, FILENAME, VERSION);

    ExceptionTest;
};

void NMBGF_OutputTranslator::PutSORCSection (NMBGF_STRING CATAGORY)
{
    NMBGF_PutSORCSection (hOC, CATAGORY);

    ExceptionTest;
};

void NMBGF_OutputTranslator::PutSUBGSection
    (NMBGF_STRING  NAME,
     NMBGF_STRING  PARENT,
     NMBGF_INTEGER Iparent,
     NMBGF_INTEGER Jparent,
     NMBGF_INTEGER NI,
     NMBGF_INTEGER NJ)
{
    NMBGF_PutSUBGSection (hOC, NAME, PARENT, Iparent, Jparent, NI, NJ);

    ExceptionTest;
};

void NMBGF_OutputTranslator::SUBG_PutGridPoint (NMBGF_FLOAT V)
{
    NMBGF_SUBG_PutGridPoint (hOC, V);

    ExceptionTest;
};

void NMBGF_OutputTranslator::PutTIMESection
    (NMBGF_INTEGER HOUR, NMBGF_INTEGER MINUTE, NMBGF_INTEGER SECOND)
{
    NMBGF_PutTIMESection (hOC, HOUR, MINUTE, SECOND);

    ExceptionTest;
};

void NMBGF_OutputTranslator::PutUTMCSection
    (NMBGF_INTEGER ZONE,
     NMBGF_FLOAT   FE,
     NMBGF_FLOAT   FN)
{
    NMBGF_PutUTMCSection (hOC, ZONE, FE, FN);

    ExceptionTest;
};

void NMBGF_OutputTranslator::PutWARNSection (NMBGF_STRING MESSAGE)
{
    NMBGF_PutWARNSection (hOC, MESSAGE);

    ExceptionTest;
};

void NMBGF_OutputTranslator::PutZCRDSection
    (NMBGF_FLOAT Z, NMBGF_ZCRD_UNIT_ENUM UNIT)
{
    NMBGF_PutZCRDSection (hOC, Z, UNIT);

    ExceptionTest;
};





