
//  Define class NMBGF_OutputTranslator, a C++ class wrapper for the
//  NMBGF_xxx C functions.
//
//  Class NMBGF_OutputTranslator has public member functions corresponding to
//  each of the NMBGF_ functions.  See the documentation associated with
//  these functions for more detail.
//
//  Using NMBGF_OutputTranslator provides the following advantages over using
//  the straight C NMBGF_xxx functions...
//
//  1. The NMBGF_EndWritingOutputFile is called automatically by the
//     NMBGF_OutputTranslator destructor.
//  2. Notational convenience: functions can be called using the standard
//     member function calling syntax: ie, OutputTranslator.PutInteger (1);
//     The user does not have to explicitedly pass the hOC parameter to
//     each function.
//  3. If an error occurs, an exception is thrown, thus freeing the user
//     from having to frequently check the NMBGF_WasError function.  The
//     throwing of exceptions can be disabled by defining the preprocessor
//     symbol NMBGF_DisableExceptions.
//
//  Note: The C++ version of the library uses the ANSI C version, so if the
//  C++ version is used, both NMBGFIOC.CPP and NMBGFIOL.C must be linked into
//  your program.




#ifndef nmbgfioc_included

#define nmbgfioc_included


#ifndef nmbgfiol_included
    #include "nmbgfiol.h"
#endif




class NMBGF_OutputTranslatorException
//
//  This class is thrown if an error occurs while executing one of the
//  NMBGF_OutputTranslator member functions.
//
{
};




class NMBGF_OutputTranslator
{
    public:

    NMBGF_OutputTranslator
        (const char*   FileName,
         unsigned long Options = NMBGF_Options_OutputMode_Binary);

    NMBGF_OutputTranslator
        (void*                  FileHandle,
         NMBGF_FileCloseFunType FileCloseFun,
         NMBGF_FileWriteFunType FileWriteFun,
         unsigned long          Options = NMBGF_Options_OutputMode_Binary);

    ~NMBGF_OutputTranslator ();


    int IsInASCIIMode ();


    int WasError ();

    void ResetErrorFlag ();



    void PushOutputStreamBuffer ();

    NMBGF_INTEGER GetTopOutputStreamBufferLengthInBytes ();

    void SetTopClientStackCounter (NMBGF_INTEGER X);

    void IncrementTopClientStackCounter ();

    NMBGF_INTEGER GetTopClientStackCounter ();

    void PutToTopOutputStreamBuffer
        (void* DataBlock, NMBGF_INTEGER DataBlockLength);

    void WriteIntegerToPreceedingBuffer (NMBGF_INTEGER Count);

    void PopOutputStreamBuffer ();

    void AutoClosePreviousSection ();


    void BeginOptionalSubsections ();

    void EndOptionalSubsections ();


    void PutStandardSectionProlog (NMBGF_LITERAL SectionName);


    void PutLiteral    (NMBGF_LITERAL    X);
    void PutString     (NMBGF_STRING     X);
    void PutInteger    (NMBGF_INTEGER    X);
    void PutFloat      (NMBGF_FLOAT      X);
    void PutCoordinate (NMBGF_COORDINATE X);



    void PutAREMSection (NMBGF_STRING CATAGORY);

            void AREM_BeginPoints ();

                void AREM_PutPoint (NMBGF_COORDINATE P);

            void AREM_PointsDone ();

        void AREM_ClosedPolygonsDone ();


    void PutARESSection (NMBGF_STRING CATAGORY);

            void ARES_PutPoint (NMBGF_COORDINATE P);

        void ARES_PointsDone ();


    void PutATRCSection (NMBGF_STRING NAME, NMBGF_COORDINATE VALUE);


    void PutATRFSection (NMBGF_STRING NAME, NMBGF_FLOAT VALUE);


    void PutATRISection (NMBGF_STRING NAME, NMBGF_INTEGER VALUE);


    void PutATRSSection (NMBGF_STRING NAME, NMBGF_STRING VALUE);


    void PutATRTSection (NMBGF_STRING NAME);

                void ATRT_AddColumn
                    (NMBGF_STRING COLNAME, NMBGF_ATRT_COLTYPE_ENUM COLTYPE);

            void ATRT_ColumnsDone ();

                void ATRT_PutString (NMBGF_STRING X);

                void ATRT_PutInteger (NMBGF_INTEGER X);

                void ATRT_PutFloat (NMBGF_FLOAT X);

                void ATRT_PutCoordinate (NMBGF_COORDINATE X);

            void ATRT_RowDone ();

        void ATRT_TableDone ();


    void PutBKMPSection (NMBGF_STRING FILENAME, NMBGF_STRING CATEGORY);


    void PutCARTSection
        (NMBGF_FLOAT           LOR,
         NMBGF_FLOAT           LAR,
         NMBGF_FLOAT           XR,
         NMBGF_FLOAT           YR,
         NMBGF_CART_UNIT_ENUM  UNIT,
         NMBGF_FLOAT           ROT);


    void PutDAPYSection ();

            void DAPY_BeginPoints ();

                void DAPY_PutPoint (NMBGF_COORDINATE P);

            void DAPY_PointsDone ();

        void DAPY_ClosedPolygonsDone ();


    void PutDATESection
        (NMBGF_INTEGER DAY, NMBGF_INTEGER MONTH, NMBGF_INTEGER YEAR);


    void PutDESLSection (NMBGF_STRING D);


    void PutDESSSection (NMBGF_STRING D);


    void PutDPALSection ();

            void DPAL_PutDataPoint (NMBGF_COORDINATE P, NMBGF_FLOAT V);

        void DPAL_DataPointsDone ();


    void PutGRIDSection
        (NMBGF_STRING          NAME,
         NMBGF_INTEGER         NI,
         NMBGF_INTEGER         NJ,
         NMBGF_FLOAT           DI,
         NMBGF_FLOAT           DJ,
         NMBGF_GRID_UNIT_ENUM  UNIT,
         NMBGF_COORDINATE      ORIGIN,
         NMBGF_FLOAT           ROT);

        void GRID_PutGridPoint (NMBGF_FLOAT V);


    void PutGTSHSection (NMBGF_FLOAT VMIN, NMBGF_FLOAT VMAX);


    void PutHEADSection (NMBGF_FLOAT H);


    void PutLINCSection
        (NMBGF_STRING          CATAGORY,
         NMBGF_LINC_UNIT_ENUM  UNIT,
         NMBGF_COORDINATE      P0,
         NMBGF_FLOAT           H0);

            void LINC_PutDSTRCommand (NMBGF_FLOAT DIST);

            void LINC_PutDARRCommand (NMBGF_FLOAT ANGLE, NMBGF_FLOAT RADIUS);

            void LINC_PutDALACommand (NMBGF_FLOAT HEAD, NMBGF_FLOAT RADIUS);

            void LINC_PutDARACommand (NMBGF_FLOAT HEAD, NMBGF_FLOAT RADIUS);

            void LINC_PutDAPTCommand (NMBGF_COORDINATE P);

            void LINC_PutDAPHCommand (NMBGF_COORDINATE P, NMBGF_FLOAT HEAD);

            void LINC_PutMSTRCommand (NMBGF_FLOAT DIST);

            void LINC_PutMARRCommand (NMBGF_FLOAT ANGLE, NMBGF_FLOAT RADIUS);

            void LINC_PutMALACommand (NMBGF_FLOAT HEAD, NMBGF_FLOAT RADIUS);

            void LINC_PutMARACommand (NMBGF_FLOAT HEAD, NMBGF_FLOAT RADIUS);

            void LINC_PutMAPTCommand (NMBGF_COORDINATE P);

            void LINC_PutMAPHCommand (NMBGF_COORDINATE P, NMBGF_FLOAT HEAD);

            void LINC_PutTNRLCommand (NMBGF_FLOAT ANGLE);

            void LINC_PutTNAHCommand (NMBGF_FLOAT HEAD);

            void LINC_PutTRFPCommand (NMBGF_COORDINATE P);

            void LINC_PutTL90Command ();

            void LINC_PutTR90Command ();

            void LINC_PutT180Command ();

        void LINC_CommandsDone ();


    void PutLINMSection (NMBGF_STRING CATAGORY);

            void LINM_BeginPoints ();

                void LINM_PutPoint (NMBGF_COORDINATE P);

            void LINM_PointsDone ();

        void LINM_ContinuousLinesDone ();


    void PutLINSSection (NMBGF_STRING CATAGORY);

            void LINS_PutPoint (NMBGF_COORDINATE P);

        void LINS_PointsDone ();


    void PutMTRCSection (NMBGF_STRING TYPE, NMBGF_STRING UNIT);


    void PutPERSSection
        (NMBGF_STRING  NAME,
         NMBGF_STRING  TITLE,
         NMBGF_STRING  COMPANY,
         NMBGF_STRING  ADDRESS,
         NMBGF_STRING  PHONE,
         NMBGF_STRING  FAX,
         NMBGF_STRING  EMAIL);


    void PutPNTMSection (NMBGF_STRING CATAGORY);

            void PNTM_PutPoint (NMBGF_COORDINATE P);

        void PNTM_PointsDone ();


    void PutPNTSSection (NMBGF_STRING CATAGORY, NMBGF_COORDINATE P);


    void PutPROGSection
        (NMBGF_STRING USERNAME, NMBGF_STRING FILENAME, NMBGF_FLOAT VERSION);


    void PutSORCSection (NMBGF_STRING CATAGORY);


    void PutSUBGSection
        (NMBGF_STRING   NAME,
         NMBGF_STRING   PARENT,
         NMBGF_INTEGER  Iparent,
         NMBGF_INTEGER  Jparent,
         NMBGF_INTEGER  NI,
         NMBGF_INTEGER  NJ);

        void SUBG_PutGridPoint (NMBGF_FLOAT V);


    void PutTIMESection
        (NMBGF_INTEGER HOUR, NMBGF_INTEGER MINUTE, NMBGF_INTEGER SECOND);


    void PutUTMCSection
        (NMBGF_INTEGER ZONE,
         NMBGF_FLOAT   FE,
         NMBGF_FLOAT   FN);


    void PutWARNSection (NMBGF_STRING MESSAGE);


    void PutZCRDSection (NMBGF_FLOAT Z, NMBGF_ZCRD_UNIT_ENUM UNIT);


    private:

    NMBGF_HOC hOC;


    NMBGF_OutputTranslator& operator = (const NMBGF_OutputTranslator&);
        //  Disallow assignment
};




#endif

